/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import org.geotools.geometry.AbstractDirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class DirectPosition1D
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3235094562875693710L;
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(double d) {
        this.ordinate = d;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    @Override
    public double[] getCoordinate() {
        return new double[]{this.ordinate};
    }

    @Override
    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    @Override
    public final void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.ordinate = d;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.ordinate);
        int n = 31 + ((int)l ^ (int)(l >>> 32));
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public DirectPosition1D clone() {
        try {
            return (DirectPosition1D)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

