/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.FallbackFunction;
import org.geotools.filter.FunctionFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FunctionFinder {
    private volatile Map<String, FunctionFactory> functionFactoryCache;

    public FunctionFinder(Hints hints) {
    }

    public Function findFunction(String string, List list) {
        return this.findFunction(string, list, null);
    }

    public Function findFunction(String string, List list, Literal literal) {
        Function function = this.findFunctionInternal(string, list, literal);
        if (function == null && string.endsWith("Function")) {
            string = string.substring(0, string.length() - "Function".length());
            function = this.findFunctionInternal(string, list, literal);
        }
        if (function == null && literal != null) {
            return new FallbackFunction(string, list, literal);
        }
        if (function != null) {
            return function;
        }
        throw new RuntimeException("Unable to find function " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Function findFunctionInternal(String string, List list, Literal literal) {
        Object object;
        if (this.functionFactoryCache == null) {
            object = this;
            synchronized (object) {
                if (this.functionFactoryCache == null) {
                    this.functionFactoryCache = this.lookupFunctions();
                }
            }
        }
        if (this.functionFactoryCache.containsKey(string)) {
            return this.functionFactoryCache.get(string).function(string, list, literal);
        }
        object = null;
        for (FunctionFactory functionFactory : CommonFactoryFinder.getFunctionFactories(null)) {
            object = functionFactory.function(string, list, literal);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private HashMap lookupFunctions() {
        HashMap<String, FunctionFactory> hashMap = new HashMap<String, FunctionFactory>();
        Set<FunctionFactory> set = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory functionFactory : set) {
            for (FunctionName functionName : functionFactory.getFunctionNames()) {
                hashMap.put(functionName.getName(), functionFactory);
            }
        }
        return hashMap;
    }
}

