/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiPointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public MultiPointHandler(ShapeType shapeType, GeometryFactory geometryFactory) throws ShapefileException {
        if (shapeType != ShapeType.MULTIPOINT && shapeType != ShapeType.MULTIPOINTM && shapeType != ShapeType.MULTIPOINTZ) {
            throw new ShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.shapeType = shapeType;
        this.geometryFactory = geometryFactory;
    }

    private Object createNull() {
        Coordinate[] coordinateArray = null;
        return this.geometryFactory.createMultiPoint(coordinateArray);
    }

    @Override
    public Object read(ByteBuffer byteBuffer, ShapeType shapeType, boolean bl) {
        int n;
        if (shapeType == ShapeType.NULL) {
            return this.createNull();
        }
        byteBuffer.position(byteBuffer.position() + 32);
        int n2 = byteBuffer.getInt();
        int n3 = this.shapeType == ShapeType.MULTIPOINTZ && !bl ? 3 : 2;
        CoordinateSequence coordinateSequence = this.geometryFactory.getCoordinateSequenceFactory().create(n2, n3);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        double[] dArray = new double[n2 * 2];
        doubleBuffer.get(dArray);
        for (n = 0; n < n2; ++n) {
            coordinateSequence.setOrdinate(n, 0, dArray[n * 2]);
            coordinateSequence.setOrdinate(n, 1, dArray[n * 2 + 1]);
        }
        if (n3 > 2) {
            doubleBuffer.position(doubleBuffer.position() + 2);
            doubleBuffer.get(dArray, 0, n2);
            for (n = 0; n < n2; ++n) {
                coordinateSequence.setOrdinate(n, 2, dArray[n]);
            }
        }
        return this.geometryFactory.createMultiPoint(coordinateSequence);
    }
}

