/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public class FeatureListenerManager {
    Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> listenerMap = new WeakHashMap<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList>();

    public void addFeatureListener(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, FeatureListener featureListener) {
        this.eventListenerList(featureSource).add(FeatureListener.class, featureListener);
    }

    void removeFeatureListener(WeakFeatureListener weakFeatureListener) {
        for (EventListenerList eventListenerList : this.listenerMap.values()) {
            eventListenerList.remove(FeatureListener.class, weakFeatureListener);
        }
    }

    public void removeFeatureListener(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, FeatureListener featureListener) {
        EventListenerList eventListenerList = this.eventListenerList(featureSource);
        eventListenerList.remove(FeatureListener.class, featureListener);
        if (eventListenerList.getListenerCount() == 0) {
            this.cleanListenerList(featureSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventListenerList eventListenerList(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> map = this.listenerMap;
        synchronized (map) {
            if (this.listenerMap.containsKey(featureSource)) {
                return this.listenerMap.get(featureSource);
            }
            EventListenerList eventListenerList = new EventListenerList();
            this.listenerMap.put(featureSource, eventListenerList);
            return eventListenerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanListenerList(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> map = this.listenerMap;
        synchronized (map) {
            this.listenerMap.remove(featureSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SimpleFeatureSource, FeatureListener[]> getListeners(String string, Transaction transaction) {
        HashMap<SimpleFeatureSource, FeatureListener[]> hashMap = new HashMap<SimpleFeatureSource, FeatureListener[]>();
        Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> map = this.listenerMap;
        synchronized (map) {
            for (Map.Entry<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> entry : this.listenerMap.entrySet()) {
                EventListenerList eventListenerList;
                FeatureListener[] featureListenerArray;
                SimpleFeatureSource simpleFeatureSource = (SimpleFeatureSource)entry.getKey();
                if (!simpleFeatureSource.getName().getLocalPart().equals(string) || transaction != Transaction.AUTO_COMMIT && FeatureListenerManager.hasTransaction(simpleFeatureSource) && transaction != FeatureListenerManager.getTransaction(simpleFeatureSource) || (featureListenerArray = (FeatureListener[])(eventListenerList = entry.getValue()).getListeners(FeatureListener.class)).length == 0) continue;
                hashMap.put(simpleFeatureSource, featureListenerArray);
            }
        }
        return hashMap;
    }

    private static boolean hasTransaction(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        return featureSource instanceof FeatureStore && ((FeatureStore)featureSource).getTransaction() != null;
    }

    private static Transaction getTransaction(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        if (FeatureListenerManager.hasTransaction(featureSource)) {
            return ((FeatureStore)featureSource).getTransaction();
        }
        return Transaction.AUTO_COMMIT;
    }

    public void fireFeaturesAdded(String string, Transaction transaction, ReferencedEnvelope referencedEnvelope, boolean bl) {
        if (bl) {
            this.fireCommit(string, transaction, 1, referencedEnvelope);
        } else {
            this.fireEvent(string, transaction, 1, referencedEnvelope);
        }
    }

    public void fireFeaturesChanged(String string, Transaction transaction, ReferencedEnvelope referencedEnvelope, boolean bl) {
        if (bl) {
            this.fireCommit(string, transaction, 0, referencedEnvelope);
        } else {
            this.fireEvent(string, transaction, 0, referencedEnvelope);
        }
    }

    private void fireCommit(String string, Transaction transaction, int n, ReferencedEnvelope referencedEnvelope) {
        Map<SimpleFeatureSource, FeatureListener[]> map = this.getListeners(string, Transaction.AUTO_COMMIT);
        for (Map.Entry<SimpleFeatureSource, FeatureListener[]> entry : map.entrySet()) {
            FeatureSource featureSource = entry.getKey();
            FeatureListener[] featureListenerArray = entry.getValue();
            if (FeatureListenerManager.hasTransaction(featureSource) && FeatureListenerManager.getTransaction(featureSource) == transaction) continue;
            FeatureEvent featureEvent = new FeatureEvent(featureSource, n, referencedEnvelope);
            for (int i = 0; i < featureListenerArray.length; ++i) {
                featureListenerArray[i].changed(featureEvent);
            }
        }
    }

    private void fireEvent(String string, Transaction transaction, int n, ReferencedEnvelope referencedEnvelope) {
        Map<SimpleFeatureSource, FeatureListener[]> map = this.getListeners(string, transaction);
        for (Map.Entry<SimpleFeatureSource, FeatureListener[]> entry : map.entrySet()) {
            FeatureSource featureSource = entry.getKey();
            FeatureListener[] featureListenerArray = entry.getValue();
            FeatureEvent featureEvent = new FeatureEvent(featureSource, n, referencedEnvelope);
            for (int i = 0; i < featureListenerArray.length; ++i) {
                featureListenerArray[i].changed(featureEvent);
            }
        }
    }

    public void fireFeaturesRemoved(String string, Transaction transaction, ReferencedEnvelope referencedEnvelope, boolean bl) {
        if (bl) {
            this.fireCommit(string, transaction, -1, referencedEnvelope);
        } else {
            this.fireEvent(string, transaction, -1, referencedEnvelope);
        }
    }

    class WeakFeatureListener
    implements FeatureListener {
        WeakReference<FeatureListener> reference;

        WeakFeatureListener() {
        }

        @Override
        public void changed(FeatureEvent featureEvent) {
            FeatureListener featureListener = (FeatureListener)this.reference.get();
            if (featureListener == null) {
                FeatureListenerManager.this.removeFeatureListener(this);
            } else {
                featureListener.changed(featureEvent);
            }
        }
    }
}

