/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMNode;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.ColorSchemeXMLReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChannelDiGraphLayer
extends Layer
implements MapView.LayerChangeListener,
PropertyChangeListener {
    private ChannelDiGraph digraph;
    private static final int POINTSIZE = 5;
    private static final float LINEWIDTH = 4.0f;
    private final ColorSchemeXMLReader cXMLReader;
    private static final Shape ARROW_HEAD;
    private Color twoWayChannelColor;
    private Color oneWayChannelColor;
    private Color toNodeColor;
    private Color fromNodeColor;
    private Color nsccChannelColor;
    private Color selectedChannelColor;
    private Color partOfJunctionColor;

    public ChannelDiGraphLayer(ColorSchemeXMLReader cXMLReader) {
        super("ChannelDiGraphLayer");
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        this.cXMLReader = cXMLReader;
        this.initColors();
    }

    public void initColors() {
        this.twoWayChannelColor = this.cXMLReader.getColor("TwoWayChannel");
        this.oneWayChannelColor = this.cXMLReader.getColor("OneWayChannel");
        this.toNodeColor = this.cXMLReader.getColor("ToNode");
        this.fromNodeColor = this.cXMLReader.getColor("FromNode");
        this.nsccChannelColor = this.cXMLReader.getColor("NotConnectedChannel");
        this.selectedChannelColor = this.cXMLReader.getColor("selectedChannel");
        this.partOfJunctionColor = this.cXMLReader.getColor("partOfJunction");
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"dialogs", (String)"junctionchecker");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        Action[] action = new Action[]{};
        return action;
    }

    public String getToolTipText() {
        return I18n.tr((String)"Channel-Digraph created from the active OSM-Layer", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (this.digraph != null) {
            for (int i = 0; i < this.digraph.getChannels().size(); ++i) {
                this.paintChannel(this.digraph.getChannelAtPosition(i), g, mv);
            }
        }
    }

    private void paintChannel(Channel channel, Graphics2D g, MapView mv) {
        Point fromPoint = this.getCoord(channel.getFromNode(), mv);
        g.setColor(this.fromNodeColor);
        g.fillOval(fromPoint.x - 5, fromPoint.y - 5, 10, 10);
        Point toPoint = this.getCoord(channel.getToNode(), mv);
        g.setColor(this.toNodeColor);
        g.fillOval(toPoint.x - 5, toPoint.y - 5, 10, 10);
        Color c = channel.isPartOfJunction() ? this.partOfJunctionColor : (channel.isSelected() ? this.selectedChannelColor : (!channel.isStrongConnected() ? this.nsccChannelColor : (channel.getBackChannelID() != -100 ? this.twoWayChannelColor : this.oneWayChannelColor)));
        g.setColor(c);
        g.setStroke(new BasicStroke(4.0f));
        g.draw(new Line2D.Float(fromPoint.x, fromPoint.y, toPoint.x, toPoint.y));
        double angle = this.angleFromXAxis(fromPoint, toPoint);
        Shape head = ARROW_HEAD;
        head = AffineTransform.getRotateInstance(angle).createTransformedShape(head);
        head = AffineTransform.getTranslateInstance(toPoint.x, toPoint.y).createTransformedShape(head);
        g.fill(head);
    }

    private Point getCoord(OSMNode node, MapView mv) {
        return mv.getPoint(Main.getProjection().latlon2eastNorth(new LatLon(node.getLatitude(), node.getLongitude())));
    }

    private double angleFromXAxis(Point p1, Point p2) {
        assert (p1 != null && p2 != null);
        float vecX = p2.x - p1.x;
        float vecY = p2.y - p1.y;
        float vecLength = (float)Math.sqrt(vecX * vecX + vecY * vecY);
        float dotProductVecAxis = vecX;
        float angle = (float)Math.acos(dotProductVecAxis / vecLength);
        if (p2.y < p1.y) {
            angle = -angle;
        }
        assert (-1.5707963267948966 < (double)angle && (double)angle <= 1.5707963267948966);
        return angle;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public void setDiGraph(ChannelDiGraph digraph) {
        this.digraph = digraph;
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this) {
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
        }
    }

    public ChannelDiGraph getDigraph() {
        return this.digraph;
    }

    public void setDigraph(ChannelDiGraph digraph) {
        this.digraph = digraph;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    static {
        Polygon head = new Polygon();
        head.addPoint(0, 0);
        head.addPoint(-15, 4);
        head.addPoint(-15, -4);
        ARROW_HEAD = head;
    }
}

