/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MoveRouteNodeAction
extends MapMode {
    private static final long serialVersionUID = 1L;
    private static final int DRAG_SQR_RADIUS = 100;
    static Logger logger = Logger.getLogger(RoutingLayer.class);
    private RoutingDialog routingDialog = RoutingPlugin.getInstance().getRoutingDialog();
    private int index;

    public MoveRouteNodeAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Routing", (Object[])new Object[0]), "move", I18n.tr((String)"Click and drag to move destination", (Object[])new Object[0]), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
            RoutingLayer layer = (RoutingLayer)Main.map.mapView.getActiveLayer();
            RoutingModel routingModel = layer.getRoutingModel();
            List<Node> nl = routingModel.getSelectedNodes();
            this.index = -1;
            double dmax = 100.0;
            for (int i = 0; i < nl.size(); ++i) {
                Node node = nl.get(i);
                double d = Main.map.mapView.getPoint(node).distanceSq(e.getPoint());
                if (!(d < dmax)) continue;
                dmax = d;
                this.index = i;
            }
            if (this.index >= 0) {
                logger.debug("Moved from node " + nl.get(this.index));
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.index >= 0) {
            this.searchAndReplaceNode(e.getPoint());
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private void searchAndReplaceNode(Point point) {
        if (Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
            RoutingLayer layer = (RoutingLayer)Main.map.mapView.getActiveLayer();
            RoutingModel routingModel = layer.getRoutingModel();
            Node node = null;
            node = layer.getNearestHighwayNode(point);
            if (node == null) {
                logger.debug("Didn't found a close node to move to.");
                return;
            }
            logger.debug("Moved to node " + node);
            routingModel.removeNode(this.index);
            this.routingDialog.removeNode(this.index);
            routingModel.insertNode(this.index, node);
            this.routingDialog.insertNode(this.index, node);
            Main.map.repaint();
        }
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof RoutingLayer;
    }
}

