/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import com.tilusnet.josm.plugins.alignways.AlignWaysAlgnSegment;
import com.tilusnet.josm.plugins.alignways.AlignWaysSegmentMgr;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AlignWaysCmdKeepLength
extends Command {
    final AlignWaysAlgnSegment algnSeg;
    final Collection<Node> displaceableNodes;
    final Map<Node, EastNorth> calculatedNodes = new HashMap<Node, EastNorth>();
    Collection<Node> lastAffectedNodes = null;
    final EastNorth pivot;
    private final double rotationAngle;
    final Map<Node, Node> oldNodes = new HashMap<Node, Node>();

    public AlignWaysCmdKeepLength() {
        this.algnSeg = AlignWaysSegmentMgr.getInstance(Main.map.mapView).getAlgnSeg();
        WaySegment algnWS = this.algnSeg.getSegment();
        WaySegment refWS = AlignWaysSegmentMgr.getInstance(Main.map.mapView).getRefSeg().getSegment();
        this.pivot = this.algnSeg.getCurrPivotCoord();
        this.displaceableNodes = this.algnSeg.getSegmentEndPoints();
        EastNorth enRefNode1 = refWS.way.getNode(refWS.lowerIndex).getEastNorth();
        EastNorth enRefNode2 = refWS.way.getNode(refWS.lowerIndex + 1).getEastNorth();
        EastNorth enAlgnNode1 = algnWS.way.getNode(algnWS.lowerIndex).getEastNorth();
        EastNorth enAlgnNode2 = algnWS.way.getNode(algnWS.lowerIndex + 1).getEastNorth();
        double refAngle = Math.atan2(enRefNode1.north() - enRefNode2.north(), enRefNode1.east() - enRefNode2.east());
        double algnAngle = Math.atan2(enAlgnNode1.north() - enAlgnNode2.north(), enAlgnNode1.east() - enAlgnNode2.east());
        this.rotationAngle = this.normalise_angle(refAngle - algnAngle);
        for (Node n : this.displaceableNodes) {
            double cosPhi = Math.cos(this.rotationAngle);
            double sinPhi = Math.sin(this.rotationAngle);
            EastNorth oldEastNorth = n.getEastNorth();
            double x = oldEastNorth.east() - this.pivot.east();
            double y = oldEastNorth.north() - this.pivot.north();
            double nx = cosPhi * x - sinPhi * y + this.pivot.east();
            double ny = sinPhi * x + cosPhi * y + this.pivot.north();
            this.calculatedNodes.put(n, new EastNorth(nx, ny));
        }
    }

    private void rotateNodes(boolean setModified) {
        this.lastAffectedNodes = new HashSet<Node>();
        for (Node n : this.displaceableNodes) {
            Node nodeBackup = new Node(n);
            nodeBackup.setEastNorth(n.getEastNorth());
            this.oldNodes.put(n, nodeBackup);
            this.lastAffectedNodes.add(n);
        }
        for (Node n : this.displaceableNodes) {
            n.setEastNorth(this.calculatedNodes.get(n));
            if (!setModified) continue;
            n.setModified(true);
        }
        this.algnSeg.updatePivotsEndpoints();
    }

    private double normalise_angle(double a) {
        while (a > Math.PI) {
            a -= Math.PI * 2;
        }
        while (a <= -Math.PI) {
            a += Math.PI * 2;
        }
        if (a > 1.5707963267948966) {
            a -= Math.PI;
        } else if (a < -1.5707963267948966) {
            a += Math.PI;
        }
        return a;
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Align way segment", (Object[])new Object[0]);
    }

    public Icon getDescriptionIcon() {
        return ImageProvider.get((String)"alignways");
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (Node osm : this.displaceableNodes) {
            modified.add((OsmPrimitive)osm);
        }
    }

    public boolean executeCommand() {
        this.rotateNodes(true);
        return true;
    }

    public void undoCommand() {
        for (Node n : this.displaceableNodes) {
            Node oldNode = this.oldNodes.get(n);
            n.setCoor(oldNode.getCoor());
        }
        this.algnSeg.updatePivotsEndpoints();
    }

    public Collection<Node> getPrevAffectedNodes() {
        return this.lastAffectedNodes;
    }

    AlignableStatus areSegsAlignable() {
        Collection<Node> algnNodes = this.displaceableNodes;
        Collection<Node> refNodes = AlignWaysSegmentMgr.getInstance(Main.map.mapView).getRefSeg().getSegmentEndPoints();
        for (Node nR : refNodes) {
            if (!nR.getEastNorth().equals((Object)this.pivot)) continue;
            return AlignableStatus.ALGN_VALID;
        }
        for (Node nA : algnNodes) {
            for (Node nR : refNodes) {
                if (!nA.equals((Object)nR)) continue;
                return AlignableStatus.ALGN_INV_CONNECTED_UNSHARED_PIVOT;
            }
        }
        for (EastNorth en : this.calculatedNodes.values()) {
            if (!Projections.inverseProject((EastNorth)en).isOutSideWorld()) continue;
            return AlignableStatus.ALGN_INV_OUTSIDE_WORLD;
        }
        return AlignableStatus.ALGN_VALID;
    }

    public boolean executable() {
        AlignableStatus stat = this.areSegsAlignable();
        if (stat != AlignableStatus.ALGN_VALID) {
            this.reportInvalidCommand(stat);
            return false;
        }
        return true;
    }

    void reportInvalidCommand(AlignableStatus stat) {
        String statMsg;
        switch (stat) {
            case ALGN_INV_CONNECTED_UNSHARED_PIVOT: {
                statMsg = I18n.tr((String)"Please select two segments that don''t share any nodes\n or put the pivot on their common node.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_OUTSIDE_WORLD: {
                statMsg = I18n.tr((String)"Aligning would result nodes ''outside the world''.\nAlignment not possible.\n", (Object[])new Object[0]);
                break;
            }
            default: {
                statMsg = I18n.tr((String)"Undocumented problem occured.\n", (Object[])new Object[0]);
            }
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)statMsg, (Object[])new Object[0]), I18n.tr((String)"AlignWayS: Alignment not possible", (Object[])new Object[0]), 2);
    }

    static enum AlignableStatus {
        ALGN_VALID,
        ALGN_INV_CONNECTED_UNSHARED_PIVOT,
        ALGN_INV_OUTSIDE_WORLD,
        ALGN_INV_TOOMANY_CONNECTED_WS,
        ALGN_INV_ANGLE_PRESERVING_CONFLICT,
        ALGN_INV_XPOINT_FALLSOUT;

    }
}

