/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import org.geotools.temporal.object.DefaultDuration;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public class DefaultPeriodDuration
extends DefaultDuration
implements PeriodDuration {
    private static final InternationalString DESIGNATOR = new SimpleInternationalString("P");
    private InternationalString years;
    private InternationalString months;
    private InternationalString weeks;
    private InternationalString days;
    private static final InternationalString TIME_INDICATOR = new SimpleInternationalString("T");
    private InternationalString hours;
    private InternationalString minutes;
    private InternationalString seconds;

    public DefaultPeriodDuration(InternationalString years, InternationalString months, InternationalString week, InternationalString days, InternationalString hours, InternationalString minutes, InternationalString seconds) {
        this.years = years;
        this.months = months;
        this.weeks = week;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public DefaultPeriodDuration(long durationInMilliSeconds) {
        long yearMS = 31536000000L;
        long monthMS = 2628000000L;
        long weekMS = 604800000L;
        long dayMS = 86400000L;
        long hourMS = 3600000L;
        long minMS = 60000L;
        long secondMS = 1000L;
        SimpleInternationalString _years = null;
        SimpleInternationalString _months = null;
        SimpleInternationalString _week = null;
        SimpleInternationalString _days = null;
        SimpleInternationalString _hours = null;
        SimpleInternationalString _minutes = null;
        SimpleInternationalString _seconds = null;
        long temp = durationInMilliSeconds / yearMS;
        if (temp >= 1L) {
            _years = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * yearMS;
        }
        this.years = _years;
        temp = durationInMilliSeconds / monthMS;
        if (temp >= 1L) {
            _months = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * monthMS;
        }
        this.months = _months;
        temp = durationInMilliSeconds / weekMS;
        if (temp >= 1L) {
            _week = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * weekMS;
        }
        this.weeks = _week;
        temp = durationInMilliSeconds / dayMS;
        if (temp >= 1L) {
            _days = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * dayMS;
        }
        this.days = _days;
        temp = durationInMilliSeconds / hourMS;
        if (temp >= 1L) {
            _hours = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * hourMS;
        }
        this.hours = _hours;
        temp = durationInMilliSeconds / minMS;
        if (temp >= 1L) {
            _minutes = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * minMS;
        }
        this.minutes = _minutes;
        temp = durationInMilliSeconds / secondMS;
        if (temp >= 1L) {
            _seconds = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * secondMS;
        }
        this.seconds = _seconds;
    }

    public InternationalString getDesignator() {
        return DESIGNATOR;
    }

    public InternationalString getYears() {
        return this.years;
    }

    public InternationalString getMonths() {
        return this.months;
    }

    public InternationalString getDays() {
        return this.days;
    }

    public InternationalString getTimeIndicator() {
        return TIME_INDICATOR;
    }

    public InternationalString getHours() {
        return this.hours;
    }

    public InternationalString getMinutes() {
        return this.minutes;
    }

    public InternationalString getSeconds() {
        return this.seconds;
    }

    public void setYears(InternationalString years) {
        this.years = years;
    }

    public void setMonths(InternationalString months) {
        this.months = months;
    }

    public void setDays(InternationalString days) {
        this.days = days;
    }

    public void setHours(InternationalString hours) {
        this.hours = hours;
    }

    public void setMinutes(InternationalString minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(InternationalString seconds) {
        this.seconds = seconds;
    }

    public InternationalString getWeek() {
        return this.weeks;
    }

    public void setWeek(InternationalString week) {
        this.weeks = week;
    }

    @Override
    public long getTimeInMillis() {
        String periodDescription = this.toString();
        long yearMS = 31536000000L;
        long monthMS = 2628000000L;
        long weekMS = 604800000L;
        long dayMS = 86400000L;
        long hourMS = 3600000L;
        long minMS = 60000L;
        long secondMS = 1000L;
        long response = 0L;
        if ((periodDescription = periodDescription.substring(1)).indexOf(89) != -1) {
            int nbYear = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(89)));
            response += (long)nbYear * yearMS;
            periodDescription = periodDescription.substring(periodDescription.indexOf(89) + 1);
        }
        if (periodDescription.indexOf(77) != -1 && periodDescription.indexOf(84) == -1 || periodDescription.indexOf(84) != -1 && periodDescription.indexOf(77) < periodDescription.indexOf(84) && periodDescription.indexOf(77) != -1) {
            int nbMonth = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(77)));
            response += (long)nbMonth * monthMS;
            periodDescription = periodDescription.substring(periodDescription.indexOf(77) + 1);
        }
        if (periodDescription.indexOf(87) != -1) {
            int nbWeek = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(87)));
            response += (long)nbWeek * weekMS;
            periodDescription = periodDescription.substring(periodDescription.indexOf(87) + 1);
        }
        if (periodDescription.indexOf(68) != -1) {
            int nbDay = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(68)));
            response += (long)nbDay * dayMS;
            periodDescription = periodDescription.substring(periodDescription.indexOf(68) + 1);
        }
        if (periodDescription.indexOf(84) != -1) {
            periodDescription = periodDescription.substring(1);
        }
        if (periodDescription.indexOf(72) != -1) {
            int nbHour = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(72)));
            response += (long)nbHour * hourMS;
            periodDescription = periodDescription.substring(periodDescription.indexOf(72) + 1);
        }
        if (periodDescription.indexOf(77) != -1) {
            int nbMin = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(77)));
            response += (long)nbMin * minMS;
            periodDescription = periodDescription.substring(periodDescription.indexOf(77) + 1);
        }
        if (periodDescription.indexOf(83) != -1) {
            int nbSec = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(83)));
            response += (long)nbSec * secondMS;
            periodDescription = periodDescription.substring(periodDescription.indexOf(83) + 1);
        }
        if (periodDescription.length() != 0) {
            throw new IllegalArgumentException("The period duration string is malformed");
        }
        return response;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPeriodDuration) {
            DefaultPeriodDuration that = (DefaultPeriodDuration)object;
            return Utilities.equals(this.days, that.days) && Utilities.equals(this.hours, that.hours) && Utilities.equals(this.minutes, that.minutes) && Utilities.equals(this.months, that.months) && Utilities.equals(this.seconds, that.seconds) && Utilities.equals(this.years, that.years);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.days != null ? this.days.hashCode() : 0);
        hash = 37 * hash + (this.hours != null ? this.hours.hashCode() : 0);
        hash = 37 * hash + (this.minutes != null ? this.minutes.hashCode() : 0);
        hash = 37 * hash + (this.months != null ? this.months.hashCode() : 0);
        hash = 37 * hash + (this.seconds != null ? this.seconds.hashCode() : 0);
        hash = 37 * hash + (this.years != null ? this.years.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append((CharSequence)DESIGNATOR);
        if (this.years != null) {
            s.append((CharSequence)this.years).append("Y");
        }
        if (this.months != null) {
            s.append((CharSequence)this.months).append("M");
        }
        if (this.weeks != null) {
            s.append((CharSequence)this.weeks).append("W");
        }
        if (this.days != null) {
            s.append((CharSequence)this.days).append("D");
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            s.append((CharSequence)TIME_INDICATOR);
        }
        if (this.hours != null) {
            s.append((CharSequence)this.hours).append("H");
        }
        if (this.minutes != null) {
            s.append((CharSequence)this.minutes).append("M");
        }
        if (this.seconds != null) {
            s.append((CharSequence)this.seconds).append("S");
        }
        return s.toString();
    }
}

