/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.AnchorPoint;
import org.opengis.style.LabelPlacement;
import org.opengis.util.Cloneable;

public class PointPlacementImpl
implements PointPlacement,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private final FilterFactory filterFactory;
    private AnchorPointImpl anchorPoint = new AnchorPointImpl();
    private DisplacementImpl displacement = new DisplacementImpl();
    private Expression rotation = null;

    public PointPlacementImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public PointPlacementImpl(FilterFactory factory) {
        this.filterFactory = factory;
        try {
            this.rotation = this.filterFactory.literal((Object)new Integer(0));
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultPointPlacement: " + ife);
        }
    }

    @Override
    public AnchorPointImpl getAnchorPoint() {
        return this.anchorPoint;
    }

    @Override
    public void setAnchorPoint(AnchorPoint anchorPoint) {
        if (this.anchorPoint == anchorPoint) {
            return;
        }
        this.anchorPoint = AnchorPointImpl.cast(anchorPoint);
    }

    @Override
    public Displacement getDisplacement() {
        return this.displacement;
    }

    @Override
    public void setDisplacement(org.opengis.style.Displacement displacement) {
        if (this.displacement == displacement) {
            return;
        }
        this.displacement = DisplacementImpl.cast(displacement);
    }

    @Override
    public Expression getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.PointPlacement)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            PointPlacementImpl clone = (PointPlacementImpl)super.clone();
            clone.anchorPoint = (AnchorPointImpl)this.anchorPoint.clone();
            clone.displacement = (DisplacementImpl)this.displacement.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PointPlacementImpl) {
            PointPlacementImpl other = (PointPlacementImpl)obj;
            return Utilities.equals(this.anchorPoint, other.anchorPoint) && Utilities.equals(this.displacement, other.displacement) && Utilities.equals(this.rotation, other.rotation);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.anchorPoint != null) {
            result = result * 37 + this.anchorPoint.hashCode();
        }
        if (this.displacement != null) {
            result = result * 37 + this.displacement.hashCode();
        }
        if (this.rotation != null) {
            result = result * 37 + this.rotation.hashCode();
        }
        return result;
    }

    static PointPlacementImpl cast(LabelPlacement placement) {
        if (placement == null) {
            return null;
        }
        if (placement instanceof PointPlacementImpl) {
            return (PointPlacementImpl)placement;
        }
        if (placement instanceof org.opengis.style.PointPlacement) {
            org.opengis.style.PointPlacement pointPlacement = (org.opengis.style.PointPlacement)placement;
            PointPlacementImpl copy = new PointPlacementImpl();
            copy.setAnchorPoint(AnchorPointImpl.cast(pointPlacement.getAnchorPoint()));
            copy.setDisplacement(DisplacementImpl.cast(pointPlacement.getDisplacement()));
            return copy;
        }
        return null;
    }
}

