/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.measure.CoordinateFormat;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.Spheroid;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Ellipsoid;

public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    public static final DefaultEllipsoid WGS84 = DefaultEllipsoid.createFlattenedSphere("WGS84", 6378137.0, 298.257223563, SI.METER);
    public static final DefaultEllipsoid GRS80 = DefaultEllipsoid.createFlattenedSphere("GRS80", 6378137.0, 298.257222101, SI.METER);
    public static final DefaultEllipsoid INTERNATIONAL_1924 = DefaultEllipsoid.createFlattenedSphere("International 1924", 6378388.0, 297.0, SI.METER);
    public static final DefaultEllipsoid CLARKE_1866 = DefaultEllipsoid.createFlattenedSphere("Clarke 1866", 6378206.4, 294.9786982, SI.METER);
    public static final DefaultEllipsoid SPHERE = DefaultEllipsoid.createEllipsoid("SPHERE", 6371000.0, 6371000.0, SI.METER);
    private final double semiMajorAxis;
    private final double semiMinorAxis;
    private final double inverseFlattening;
    private final boolean ivfDefinitive;
    private final Unit<Length> unit;

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super((IdentifiedObject)ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    protected DefaultEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, double inverseFlattening, boolean ivfDefinitive, Unit<Length> unit) {
        super(properties);
        this.unit = unit;
        this.semiMajorAxis = DefaultEllipsoid.check("semiMajorAxis", semiMajorAxis);
        this.semiMinorAxis = DefaultEllipsoid.check("semiMinorAxis", semiMinorAxis);
        this.inverseFlattening = DefaultEllipsoid.check("inverseFlattening", inverseFlattening);
        this.ivfDefinitive = ivfDefinitive;
        DefaultEllipsoid.ensureNonNull("unit", unit);
        DefaultEllipsoid.ensureLinearUnit(unit);
    }

    public static DefaultEllipsoid createEllipsoid(String name, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        return DefaultEllipsoid.createEllipsoid(Collections.singletonMap("name", name), semiMajorAxis, semiMinorAxis, unit);
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        if (semiMajorAxis == semiMinorAxis) {
            return new Spheroid(properties, semiMajorAxis, false, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMinorAxis, semiMajorAxis / (semiMajorAxis - semiMinorAxis), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(String name, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        return DefaultEllipsoid.createFlattenedSphere(Collections.singletonMap("name", name), semiMajorAxis, inverseFlattening, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        if (Double.isInfinite(inverseFlattening)) {
            return new Spheroid(properties, semiMajorAxis, true, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMajorAxis * (1.0 - 1.0 / inverseFlattening), inverseFlattening, true, unit);
    }

    public static DefaultEllipsoid wrap(Ellipsoid ellipsoid) {
        if (ellipsoid == null || ellipsoid instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)ellipsoid;
        }
        if (ellipsoid.isIvfDefinitive()) {
            return DefaultEllipsoid.createFlattenedSphere(DefaultEllipsoid.getProperties((IdentifiedObject)ellipsoid), ellipsoid.getSemiMajorAxis(), ellipsoid.getInverseFlattening(), (Unit<Length>)ellipsoid.getAxisUnit());
        }
        return DefaultEllipsoid.createEllipsoid(DefaultEllipsoid.getProperties((IdentifiedObject)ellipsoid), ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), (Unit<Length>)ellipsoid.getAxisUnit());
    }

    static double check(String name, double value) throws IllegalArgumentException {
        if (value > 0.0) {
            return value;
        }
        throw new IllegalArgumentException(Errors.format(58, name, value));
    }

    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getEccentricity() {
        double f = 1.0 - this.getSemiMinorAxis() / this.getSemiMajorAxis();
        return Math.sqrt(2.0 * f - f * f);
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double orthodromicDistance(Point2D P1, Point2D P2) {
        return this.orthodromicDistance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public double orthodromicDistance(double x1, double y1, double x2, double y2) {
        x1 = Math.toRadians(x1);
        y1 = Math.toRadians(y1);
        x2 = Math.toRadians(x2);
        y2 = Math.toRadians(y2);
        int MAX_ITERATIONS = 100;
        double EPS = 5.0E-14;
        double F = 1.0 / this.getInverseFlattening();
        double R = 1.0 - F;
        double tu1 = R * Math.sin(y1) / Math.cos(y1);
        double tu2 = R * Math.sin(y2) / Math.cos(y2);
        double cu1 = 1.0 / Math.sqrt(tu1 * tu1 + 1.0);
        double cu2 = 1.0 / Math.sqrt(tu2 * tu2 + 1.0);
        double su1 = cu1 * tu1;
        double s = cu1 * cu2;
        double baz = s * tu2;
        double faz = baz * tu1;
        double x = x2 - x1;
        for (int i = 0; i < 100; ++i) {
            double sx = Math.sin(x);
            double cx = Math.cos(x);
            tu1 = cu2 * sx;
            tu2 = baz - su1 * cu2 * cx;
            double sy = Math.hypot(tu1, tu2);
            double cy = s * cx + faz;
            double y = Math.atan2(sy, cy);
            double SA = s * sx / sy;
            double c2a = 1.0 - SA * SA;
            double cz = faz + faz;
            if (c2a > 0.0) {
                cz = -cz / c2a + cy;
            }
            double e = cz * cz * 2.0 - 1.0;
            double c = ((-3.0 * c2a + 4.0) * F + 4.0) * c2a * F / 16.0;
            double d = x;
            x = ((e * cy * c + cz) * sy * c + y) * SA;
            if (!(Math.abs(d - (x = (1.0 - c) * x * F + x2 - x1)) <= 5.0E-14)) continue;
            x = Math.sqrt((1.0 / (R * R) - 1.0) * c2a + 1.0) + 1.0;
            x = (x - 2.0) / x;
            c = 1.0 - x;
            c = (x * x / 4.0 + 1.0) / c;
            d = (0.375 * x * x - 1.0) * x;
            x = e * cy;
            s = 1.0 - 2.0 * e;
            s = ((((sy * sy * 4.0 - 3.0) * s * cz * d / 6.0 - x) * d / 4.0 + cz) * sy * d + y) * c * R * this.getSemiMajorAxis();
            return s;
        }
        double LEPS = 1.0E-10;
        if (Math.abs(x1 - x2) <= 1.0E-10 && Math.abs(y1 - y2) <= 1.0E-10) {
            return 0.0;
        }
        if (Math.abs(y1) <= 1.0E-10 && Math.abs(y2) <= 1.0E-10) {
            return Math.abs(x1 - x2) * this.getSemiMajorAxis();
        }
        CoordinateFormat format = new CoordinateFormat();
        throw new ArithmeticException(Errors.format(130, format.format(new GeneralDirectPosition(Math.toDegrees(x1), Math.toDegrees(y1))), format.format(new GeneralDirectPosition(Math.toDegrees(x2), Math.toDegrees(y2)))));
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultEllipsoid that = (DefaultEllipsoid)object;
            return (!compareMetadata || this.ivfDefinitive == that.ivfDefinitive) && Utilities.equals(this.semiMajorAxis, that.semiMajorAxis) && Utilities.equals(this.semiMinorAxis, that.semiMinorAxis) && Utilities.equals(this.inverseFlattening, that.inverseFlattening) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long longCode = 37L * Double.doubleToLongBits(this.semiMajorAxis);
        longCode = this.ivfDefinitive ? (long)((double)longCode + this.inverseFlattening) : (long)((double)longCode + this.semiMinorAxis);
        return (int)(longCode >>> 32) ^ (int)longCode;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        double ivf = this.getInverseFlattening();
        formatter.append(this.getAxisUnit().getConverterTo(SI.METER).convert(this.getSemiMajorAxis()));
        formatter.append(Double.isInfinite(ivf) ? 0.0 : ivf);
        return "SPHEROID";
    }
}

