/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.net.URI;
import javax.measure.unit.Unit;
import javax.media.jai.ParameterList;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.Parameter;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

final class ImagingParameter<T>
extends AbstractParameter
implements ParameterValue<T> {
    private static final long serialVersionUID = -170895429717041733L;
    private final ParameterList parameters;

    public ImagingParameter(ParameterDescriptor descriptor, ParameterList parameters) {
        super((GeneralParameterDescriptor)descriptor);
        this.parameters = parameters;
    }

    public ParameterDescriptor<T> getDescriptor() {
        return (ParameterDescriptor)super.getDescriptor();
    }

    private InvalidParameterTypeException invalidType(ClassCastException cause) {
        InvalidParameterTypeException exception = new InvalidParameterTypeException(Errors.format(72, this.getType()), ImagingParameter.getName(this.descriptor));
        exception.initCause((Throwable)cause);
        return exception;
    }

    private String getName() {
        return this.descriptor.getName().getCode();
    }

    private Class<T> getType() {
        return this.getDescriptor().getValueClass();
    }

    public Unit<?> getUnit() {
        return null;
    }

    public double doubleValue(Unit<?> unit) throws InvalidParameterTypeException {
        throw ImagingParameter.unitlessParameter(this.descriptor);
    }

    public double doubleValue() throws InvalidParameterTypeException {
        String name = this.getName();
        Class<T> type = this.getType();
        try {
            if (type.equals(Float.class)) {
                this.parameters.getFloatParameter(name);
            }
            if (type.equals(Long.class)) {
                this.parameters.getLongParameter(name);
            }
            if (type.equals(Integer.class)) {
                this.parameters.getIntParameter(name);
            }
            if (type.equals(Short.class)) {
                this.parameters.getShortParameter(name);
            }
            if (type.equals(Byte.class)) {
                this.parameters.getByteParameter(name);
            }
            return this.parameters.getDoubleParameter(name);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public int intValue() throws InvalidParameterTypeException {
        String name = this.getName();
        Class<T> type = this.getType();
        try {
            if (type.equals(Short.class)) {
                this.parameters.getShortParameter(name);
            }
            if (type.equals(Byte.class)) {
                this.parameters.getByteParameter(name);
            }
            return this.parameters.getIntParameter(name);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public boolean booleanValue() throws InvalidParameterTypeException {
        String name = this.getName();
        try {
            return this.parameters.getBooleanParameter(name);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public String stringValue() throws InvalidParameterTypeException {
        String name = this.getName();
        try {
            return ((Object)((CharSequence)this.parameters.getObjectParameter(name))).toString();
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public double[] doubleValueList(Unit<?> unit) throws InvalidParameterTypeException {
        throw ImagingParameter.unitlessParameter(this.descriptor);
    }

    public double[] doubleValueList() throws InvalidParameterTypeException {
        String name = this.getName();
        try {
            return (double[])this.parameters.getObjectParameter(name);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public int[] intValueList() throws InvalidParameterTypeException {
        String name = this.getName();
        try {
            return (int[])this.parameters.getObjectParameter(name);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public URI valueFile() throws InvalidParameterTypeException {
        String name = this.getName();
        try {
            return (URI)this.parameters.getObjectParameter(name);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public T getValue() {
        Object value;
        String name = this.getName();
        try {
            value = this.parameters.getObjectParameter(name);
        }
        catch (IllegalStateException ignore) {
            return null;
        }
        return this.getType().cast(value);
    }

    public void setValue(double value, Unit<?> unit) throws InvalidParameterValueException {
        throw ImagingParameter.unitlessParameter(this.descriptor);
    }

    public void setValue(double value) throws InvalidParameterValueException {
        String name = this.getName();
        Class<T> type = this.getType();
        try {
            if (type.equals(Float.class)) {
                this.parameters.setParameter(name, (float)value);
                return;
            }
            if (type.equals(Long.class)) {
                this.parameters.setParameter(name, (long)value);
                return;
            }
            if (type.equals(Integer.class)) {
                this.parameters.setParameter(name, (int)value);
                return;
            }
            if (type.equals(Short.class)) {
                this.parameters.setParameter(name, (short)value);
                return;
            }
            if (type.equals(Byte.class)) {
                this.parameters.setParameter(name, (byte)value);
                return;
            }
            this.parameters.setParameter(name, value);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public void setValue(int value) throws InvalidParameterValueException {
        String name = this.getName();
        Class<T> type = this.getType();
        try {
            if (type.equals(Short.class)) {
                this.parameters.setParameter(name, (short)value);
                return;
            }
            if (type.equals(Byte.class)) {
                this.parameters.setParameter(name, (byte)value);
                return;
            }
            this.parameters.setParameter(name, value);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public void setValue(boolean value) throws InvalidParameterValueException {
        String name = this.getName();
        try {
            this.parameters.setParameter(name, value);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public void setValue(Object value) throws InvalidParameterValueException {
        String name = this.getName();
        try {
            this.parameters.setParameter(name, value);
        }
        catch (ClassCastException exception) {
            throw this.invalidType(exception);
        }
    }

    public void setValue(double[] values, Unit<?> unit) throws InvalidParameterValueException {
        throw ImagingParameter.unitlessParameter(this.descriptor);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ImagingParameter that = (ImagingParameter)object;
            return Utilities.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() * 37;
        T value = this.getValue();
        if (value != null) {
            code += value.hashCode();
        }
        return code ^ 0x19FA5DBB;
    }

    @Override
    public Parameter<T> clone() {
        Parameter<T> parameter = new Parameter<T>(this.getDescriptor());
        parameter.setValue(this.getValue());
        return parameter;
    }
}

