/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.identification.RepresentativeFraction;

public class RepresentativeFractionImpl
extends Number
implements RepresentativeFraction {
    private static final long serialVersionUID = 7228422109144637537L;
    private long denominator;

    public RepresentativeFractionImpl() {
    }

    public RepresentativeFractionImpl(long denominator) {
        this.denominator = denominator;
    }

    public static RepresentativeFraction fromScale(double scale) throws IllegalArgumentException {
        if (Math.abs(scale) <= 1.0 || scale == Double.POSITIVE_INFINITY) {
            return new RepresentativeFractionImpl(Math.round(1.0 / scale));
        }
        throw new IllegalArgumentException(Errors.format(58, "scale", scale));
    }

    @Deprecated
    public double toScale() {
        return this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return 1.0 / (double)this.denominator;
    }

    @Override
    public float floatValue() {
        return 1.0f / (float)this.denominator;
    }

    @Override
    public long longValue() throws ArithmeticException {
        return this.intValue();
    }

    @Override
    public int intValue() throws ArithmeticException {
        if (this.denominator == 1L) {
            return 1;
        }
        if (this.denominator != 0L) {
            return 0;
        }
        throw new ArithmeticException();
    }

    public long getDenominator() {
        return this.denominator;
    }

    public void setDenominator(long denominator) {
        this.denominator = denominator;
    }

    public boolean equals(Object object) {
        if (object instanceof RepresentativeFraction) {
            RepresentativeFraction that = (RepresentativeFraction)object;
            return this.denominator == that.getDenominator();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.denominator;
    }
}

