/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.FidFilter;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;

public class FidFilterImpl
extends AbstractFilterImpl
implements FidFilter {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private Set fids = new HashSet();

    protected FidFilterImpl() {
        super(CommonFactoryFinder.getFilterFactory(null));
        this.filterType = (short)22;
    }

    protected FidFilterImpl(String initialFid) {
        super(CommonFactoryFinder.getFilterFactory(null));
        this.filterType = (short)22;
        this.addFid(initialFid);
    }

    protected FidFilterImpl(Set fids) {
        super(CommonFactoryFinder.getFilterFactory(null));
        this.filterType = (short)22;
        for (Object next : fids) {
            if (next instanceof Identifier) continue;
            throw new ClassCastException("Fids must implement Identifier, " + next.getClass() + " does not");
        }
        this.fids = fids;
    }

    @Override
    public final String[] getFids() {
        return this.fids().toArray(new String[0]);
    }

    public Set getIDs() {
        return this.getFidsSet();
    }

    public Set getIdentifiers() {
        return this.fids;
    }

    public void setIDs(Set ids) {
        this.fids = new HashSet();
        this.addAllFids((Collection)ids);
    }

    public Set getFidsSet() {
        return this.fids();
    }

    private Set fids() {
        TreeSet<String> set = new TreeSet<String>();
        for (Identifier id : this.fids) {
            set.add(id.getID().toString());
        }
        return set;
    }

    @Override
    public final void addFid(String fid) {
        LOGGER.finest("got fid: " + fid);
        this.fids.add(this.factory.featureId(fid));
    }

    public void addAllFids(Collection fidsToAdd) {
        if (fidsToAdd == null) {
            return;
        }
        for (String fid : fidsToAdd) {
            this.addFid(fid);
        }
    }

    @Override
    public final void removeFid(String fid) {
        if (fid == null) {
            return;
        }
        Iterator f = this.fids.iterator();
        while (f.hasNext()) {
            Identifier featureId = (Identifier)f.next();
            if (!fid.equals(featureId.getID().toString())) continue;
            f.remove();
        }
    }

    public void removeAllFids(Collection fidsToRemove) {
        if (fidsToRemove == null) {
            return;
        }
        for (String fid : fidsToRemove) {
            this.removeFid(fid);
        }
    }

    public boolean evaluate(Object feature) {
        if (feature == null) {
            return false;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String evaluate = (String)ff.property("@id").evaluate(feature, String.class);
        if (evaluate == null) {
            return false;
        }
        for (Object identifier : this.fids) {
            Identifier fid = (Identifier)identifier;
            if (!fid.getID().equals(evaluate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer fidFilter = new StringBuffer();
        Iterator fidIterator = this.fids.iterator();
        while (fidIterator.hasNext()) {
            fidFilter.append(fidIterator.next().toString());
            if (!fidIterator.hasNext()) continue;
            fidFilter.append(", ");
        }
        return "[ " + fidFilter.toString() + " ]";
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Id)this, extraData);
    }

    public boolean equals(Object filter) {
        LOGGER.finest("condition: " + filter);
        if (filter != null && filter.getClass() == this.getClass()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("condition: " + ((FidFilterImpl)filter).filterType);
            }
            if (((FidFilterImpl)filter).filterType == 22) {
                return ((Object)this.fids).equals(((FidFilterImpl)filter).fids);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.fids).hashCode();
    }
}

