/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.Parameter;
import org.geotools.factory.Factory;
import org.geotools.util.KVP;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.util.InternationalString;

public interface DataAccessFactory
extends Factory {
    public DataAccess<? extends FeatureType, ? extends Feature> createDataStore(Map<String, Serializable> var1) throws IOException;

    public String getDisplayName();

    public String getDescription();

    public Param[] getParametersInfo();

    public boolean canProcess(Map<String, Serializable> var1);

    public boolean isAvailable();

    public static class Param
    extends Parameter {
        public Param(String key) {
            this(key, String.class, null);
        }

        public Param(String key, Class<?> type) {
            this(key, type, null);
        }

        public Param(String key, Class<?> type, String description) {
            this(key, type, description, true);
        }

        public Param(String key, Class<?> type, String description, boolean required) {
            this(key, type, description, required, null);
        }

        public Param(String key, Class<?> type, String description, boolean required, Object sample) {
            this(key, type, description == null ? null : new SimpleInternationalString(description), required, sample, null);
        }

        public Param(String key, Class<?> type, InternationalString description, boolean required, Object sample) {
            super(key, type, new SimpleInternationalString(key), description, required, 1, 1, sample, null);
        }

        public Param(String key, Class<?> type, String description, boolean required, Object sample, Map<String, ?> metadata) {
            this(key, type, new SimpleInternationalString(description), required, sample, metadata);
        }

        public Param(String key, Class<?> type, String description, boolean required, Object sample, Object ... metadata) {
            this(key, type, description, required, sample, new KVP(metadata));
        }

        public Param(String key, Class<?> type, InternationalString description, boolean required, Object sample, Map<String, ?> metadata) {
            super(key, type, new SimpleInternationalString(key), description, required, 1, 1, sample, metadata);
        }

        public Object lookUp(Map<String, ?> map) throws IOException {
            if (!map.containsKey(this.key)) {
                if (this.required) {
                    throw new IOException("Parameter " + this.key + " is required:" + this.description);
                }
                return null;
            }
            Object value = map.get(this.key);
            if (value == null) {
                return null;
            }
            if (value instanceof String && this.type != String.class) {
                value = this.handle((String)value);
            }
            if (value == null) {
                return null;
            }
            if (!this.type.isInstance(value)) {
                throw new IOException(this.type.getName() + " required for parameter " + this.key + ": not " + value.getClass().getName());
            }
            return value;
        }

        public String text(Object value) {
            return value.toString();
        }

        public Object handle(String text) throws IOException {
            if (text == null) {
                return null;
            }
            if (this.type == String.class) {
                return text;
            }
            if (text.length() == 0) {
                return null;
            }
            if (this.type.isArray()) {
                StringTokenizer tokenizer = new StringTokenizer(text, " ");
                ArrayList<Object> result = new ArrayList<Object>();
                while (tokenizer.hasMoreTokens()) {
                    Object element;
                    String token = tokenizer.nextToken();
                    try {
                        element = this.type.getComponentType() == String.class ? token : this.parse(token);
                    }
                    catch (IOException ioException) {
                        throw ioException;
                    }
                    catch (Throwable throwable) {
                        throw new DataSourceException("Problem creating " + this.type.getName() + " from '" + text + "'", throwable);
                    }
                    result.add(element);
                }
                Object array = Array.newInstance(this.type.getComponentType(), result.size());
                for (int i = 0; i < result.size(); ++i) {
                    Array.set(array, i, result.get(i));
                }
                return array;
            }
            try {
                return this.parse(text);
            }
            catch (IOException ioException) {
                throw ioException;
            }
            catch (Throwable throwable) {
                throw new DataSourceException("Problem creating " + this.type.getName() + " from '" + text + "'", throwable);
            }
        }

        public Object parse(String text) throws Throwable {
            Constructor constructor;
            try {
                constructor = this.type.getConstructor(String.class);
            }
            catch (SecurityException e) {
                throw new IOException("Could not create " + this.type.getName() + " from text");
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Could not create " + this.type.getName() + " from text");
            }
            try {
                return constructor.newInstance(text);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + text + "'", illegalArgumentException);
            }
            catch (InstantiationException instantiaionException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + text + "'", instantiaionException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + text + "'", illegalAccessException);
            }
            catch (InvocationTargetException targetException) {
                throw targetException.getCause();
            }
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.key);
            buf.append('=');
            buf.append(this.type.getName());
            buf.append(' ');
            if (this.required) {
                buf.append("REQUIRED ");
            }
            buf.append((CharSequence)this.description);
            return buf.toString();
        }
    }
}

