/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class DivideByConst
extends OperationJAI {
    private static final long serialVersionUID = -3723238033407316564L;

    public DivideByConst() {
        super("DivideByConst");
    }

    @Override
    protected NumberRange deriveRange(NumberRange[] ranges, OperationJAI.Parameters parameters) {
        double[] constants = (double[])parameters.parameters.getObjectParameter("constants");
        if (constants.length == 1) {
            double c = constants[0];
            NumberRange range = ranges[0];
            double min = range.getMinimum() / c;
            double max = range.getMaximum() / c;
            return max < min ? NumberRange.create(max, min) : NumberRange.create(min, max);
        }
        return super.deriveRange(ranges, parameters);
    }
}

