/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsNull;

public class Schema {
    private static Schema DEFAULT = new Schema();
    private FilterFactory ff;

    public Schema() {
        this((Hints)null);
    }

    public Schema(Hints hints) {
        this(CommonFactoryFinder.getFilterFactory(hints));
    }

    public Schema(FilterFactory filterFactory) {
        this.ff = filterFactory;
    }

    public int getAttributeCount(SimpleFeatureType featureType) {
        return this.getNames(featureType).size();
    }

    public List getNames(SimpleFeatureType featureType) {
        return this.getNames(featureType, new ArrayList());
    }

    public List getNames(SimpleFeatureType featureType, List names) {
        List attributes;
        if (featureType == null || featureType.getAttributeDescriptors() == null) {
            return names;
        }
        List<FeatureType> ancestors = FeatureTypes.getAncestors((FeatureType)featureType);
        if (ancestors != null && !ancestors.isEmpty()) {
            int length = ancestors.size();
            for (int i = 0; i < length; ++i) {
                SimpleFeatureType superType = (SimpleFeatureType)ancestors.get(i);
                this.getNames(superType, names);
            }
        }
        if ((attributes = featureType.getAttributeDescriptors()) != null && !attributes.isEmpty()) {
            int length = attributes.size();
            for (int i = 0; i < length; ++i) {
                AttributeDescriptor type = (AttributeDescriptor)attributes.get(i);
                String name = type.getLocalName();
                if (names.contains(name)) continue;
                names.add(name);
            }
        }
        return names;
    }

    public List getAttributes(SimpleFeatureType featureType) {
        return this.getAttributes(featureType, new ArrayList());
    }

    public List getAttributes(SimpleFeatureType featureType, List list) {
        List attributes;
        if (featureType == null || featureType.getAttributeDescriptors() == null) {
            return list;
        }
        List<FeatureType> ancestors = FeatureTypes.getAncestors((FeatureType)featureType);
        if (ancestors != null && !ancestors.isEmpty()) {
            int length = ancestors.size();
            for (int i = 0; i < length; ++i) {
                this.getAttributes((SimpleFeatureType)ancestors.get(i), list);
            }
        }
        if ((attributes = featureType.getAttributeDescriptors()) != null && !attributes.isEmpty()) {
            int length = attributes.size();
            for (int i = 0; i < length; ++i) {
                AttributeDescriptor type = (AttributeDescriptor)attributes.get(i);
                String name = type.getLocalName();
                int index = this.getIndexOf(list, name);
                if (index != -1) {
                    AttributeDescriptor origional = (AttributeDescriptor)list.get(index);
                    list.remove(index);
                    list.add(index, this.override(origional, type));
                    continue;
                }
                list.add(type);
            }
        }
        return list;
    }

    public Filter getRestrictions(SimpleFeatureType featureType, String name) {
        if (featureType == null || featureType.getAttributeDescriptors() == null) {
            return Filter.EXCLUDE;
        }
        List restrictions = this.restriction(featureType, name, Collections.singletonList(Filter.INCLUDE));
        return (Filter)restrictions.get(0);
    }

    public int getIndexOf(SimpleFeatureType type, String name) {
        List names = this.getNames(type);
        return names.indexOf(name);
    }

    public AttributeDescriptor getAttribute(SimpleFeatureType type, int index) {
        String name = (String)this.getNames(type).get(index);
        return this.getXPath(type, name);
    }

    public AttributeDescriptor getAttribute(SimpleFeatureType type, String name) {
        List list = this.getAttributes(type);
        int index = this.getIndexOf(list, name);
        if (index == -1) {
            return null;
        }
        return (AttributeDescriptor)list.get(index);
    }

    public AttributeDescriptor getXPath(SimpleFeatureType type, String xpath) {
        return this.getAttribute(type, xpath);
    }

    private int getIndexOf(List attributes, String name) {
        int index = 0;
        for (AttributeDescriptor type : attributes) {
            if (name.equals(type.getLocalName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private AttributeDescriptor override(AttributeDescriptor type, AttributeDescriptor override) {
        String name;
        int min;
        int max = override.getMaxOccurs();
        if (max < 0) {
            max = type.getMinOccurs();
        }
        if ((min = override.getMinOccurs()) < 0) {
            min = type.getMinOccurs();
        }
        if ((name = override.getLocalName()) == null) {
            name = type.getLocalName();
        }
        List restrictions = this.override(type.getType().getRestrictions(), override.getType().getRestrictions());
        Class javaType = override.getType().getBinding();
        if (javaType == null) {
            javaType = type.getType().getBinding();
        }
        boolean isNilable = override.isNillable();
        Object defaultValue = override.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = type.getDefaultValue();
        }
        return new AttributeDescriptorImpl(new AttributeTypeImpl(new NameImpl(name), javaType, false, false, restrictions, null, null), new NameImpl(name), min, max, isNilable, defaultValue);
    }

    private List restriction(SimpleFeatureType featureType, String name, List filters) {
        List attributes;
        List<FeatureType> ancestors = FeatureTypes.getAncestors((FeatureType)featureType);
        if (ancestors != null && !ancestors.isEmpty()) {
            int length = ancestors.size();
            for (int i = 0; i < length; ++i) {
                SimpleFeatureType superType = (SimpleFeatureType)ancestors.get(i);
                filters = this.restriction(superType, name, filters);
            }
        }
        if ((attributes = featureType.getAttributeDescriptors()) != null && !attributes.isEmpty()) {
            int length = attributes.size();
            for (int i = 0; i < length; ++i) {
                AttributeDescriptor type = (AttributeDescriptor)attributes.get(i);
                if (!name.equals(type.getLocalName())) continue;
                filters = this.override(filters, type.getType().getRestrictions());
            }
        }
        return filters;
    }

    private List override(List filters, List overrides) {
        if (filters.size() != overrides.size()) {
            throw new IllegalArgumentException("filters not same size");
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < filters.size(); ++i) {
            Filter f = this.override((Filter)filters.get(i), (Filter)overrides.get(i));
        }
        return result;
    }

    private Filter override(Filter filter, Filter override) {
        if (this.isNOP(override)) {
            return filter;
        }
        if (this.isNOP(filter)) {
            return override;
        }
        return this.ff.and(filter, override);
    }

    private boolean isNOP(Filter filter) {
        return filter == null || filter instanceof PropertyIsNull || filter == Filter.INCLUDE;
    }

    public static int attributeCount(SimpleFeatureType featureType) {
        return DEFAULT.getAttributeCount(featureType);
    }

    public static AttributeDescriptor attribute(SimpleFeatureType type, int index) {
        return DEFAULT.getAttribute(type, index);
    }

    public static AttributeDescriptor attribute(SimpleFeatureType type, String name) {
        return DEFAULT.getAttribute(type, name);
    }

    public static List attributes(SimpleFeatureType featureType) {
        return DEFAULT.getAttributes(featureType);
    }

    public static List attributes(SimpleFeatureType featureType, List list) {
        return DEFAULT.getAttributes(featureType, list);
    }

    public static int find(SimpleFeatureType type, String name) {
        return DEFAULT.getIndexOf(type, name);
    }

    public static List names(SimpleFeatureType featureType) {
        return DEFAULT.getNames(featureType);
    }

    public static List names(SimpleFeatureType featureType, List names) {
        return DEFAULT.getNames(featureType, names);
    }

    public static Filter restriction(SimpleFeatureType featureType, String name) {
        return DEFAULT.getRestrictions(featureType, name);
    }

    public static AttributeDescriptor xpath(SimpleFeatureType type, String xpath) {
        return DEFAULT.getAttribute(type, xpath);
    }
}

