/*
 * Decompiled with CFR 0.152.
 */
package poly;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeMap;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmExporter;
import poly.PolyType;

public class PolyExporter
extends OsmExporter {
    public PolyExporter() {
        super(PolyType.FILE_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData(File file, Layer layer) throws IOException {
        if (layer instanceof OsmDataLayer) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            try {
                DataSet ds = ((OsmDataLayer)layer).data;
                TreeMap<Way, Boolean> ways = new TreeMap<Way, Boolean>(new AreaComparator());
                String polygonName = file.getName();
                if (polygonName.indexOf(46) > 0) {
                    polygonName = polygonName.substring(0, polygonName.indexOf(46));
                }
                for (Way w : ds.getWays()) {
                    if (!w.isClosed()) continue;
                    boolean outer = true;
                    for (OsmPrimitive p : w.getReferrers()) {
                        if (p instanceof Relation && ((Relation)p).isMultipolygon()) {
                            for (RelationMember m : ((Relation)p).getMembers()) {
                                if (!m.refersTo((OsmPrimitive)w) || !"inner".equals(m.getRole())) continue;
                                outer = false;
                                break;
                            }
                        }
                        if (outer) continue;
                        break;
                    }
                    ways.put(w, outer);
                    if (!w.hasKey("name")) continue;
                    polygonName = w.get("name").replace("\n", " ");
                }
                int counter = 1;
                writer.write(polygonName);
                writer.newLine();
                for (Way w : ways.keySet()) {
                    if (!((Boolean)ways.get(w)).booleanValue()) {
                        writer.write(33);
                    }
                    writer.write(w.hasKey("ref") ? w.get("ref") : String.valueOf(counter++));
                    writer.newLine();
                    for (Node n : w.getNodes()) {
                        writer.write(String.format(Locale.ENGLISH, "   %E   %E", n.getCoor().lon(), n.getCoor().lat()));
                        writer.newLine();
                    }
                    writer.write("END");
                    writer.newLine();
                }
                writer.write("END");
                writer.newLine();
            }
            finally {
                writer.close();
            }
        }
    }

    private class AreaComparator
    implements Comparator<Way> {
        private AreaComparator() {
        }

        @Override
        public int compare(Way w1, Way w2) {
            if (w1.hasKey("ref") && !w2.hasKey("ref")) {
                return -1;
            }
            if (!w1.hasKey("ref") && w2.hasKey("ref")) {
                return 1;
            }
            if (w1.hasKey("ref") && w2.hasKey("ref") && !w1.get("ref").equals(w2.get("ref"))) {
                return w1.get("ref").compareTo(w2.get("ref"));
            }
            return w1.compareTo((OsmPrimitive)w2);
        }
    }
}

