/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.curves;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.curves.CircleArcMaker;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurveAction
extends JosmAction {
    private static final long serialVersionUID = 1L;
    private int angleSeparation = -1;

    public CurveAction() {
        super(I18n.tr((String)"Circle arc", (Object[])new Object[0]), "circlearc", I18n.tr((String)"Create a circle arc", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:createcurve", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Create a circle arc", (Object[])new Object[0])}), (int)67, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/CreateCircleArc"));
        this.updatePreferences();
    }

    private void updatePreferences() {
        this.angleSeparation = Main.pref.getInteger(this.prefKey("circlearc.angle-separation"), 20);
    }

    private String prefKey(String subKey) {
        return "curves." + subKey;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.updatePreferences();
        ArrayList<Node> selectedNodes = new ArrayList<Node>(CurveAction.getCurrentDataSet().getSelectedNodes());
        ArrayList<Way> selectedWays = new ArrayList<Way>(CurveAction.getCurrentDataSet().getSelectedWays());
        Collection<Command> cmds = CircleArcMaker.doCircleArc(selectedNodes, selectedWays, this.angleSeparation);
        if (cmds != null) {
            Main.main.undoRedo.add((Command)new SequenceCommand("Create a curve", cmds));
        }
    }

    protected void updateEnabledState() {
        if (CurveAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CurveAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    public static void main(String[] args) {
    }
}

