/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack<Item>
implements Iterable<Item> {
    private int N = 0;
    private Node first = null;

    public Stack() {
        assert (this.check());
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.N;
    }

    public void push(Item item) {
        Node oldfirst = this.first;
        this.first = new Node();
        this.first.item = item;
        this.first.next = oldfirst;
        ++this.N;
        assert (this.check());
    }

    public Item pop() {
        if (this.isEmpty()) {
            throw new RuntimeException("Stack underflow");
        }
        Object item = this.first.item;
        this.first = this.first.next;
        --this.N;
        assert (this.check());
        return (Item)item;
    }

    public Item peek() {
        if (this.isEmpty()) {
            throw new RuntimeException("Stack underflow");
        }
        return (Item)this.first.item;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Item item : this) {
            s.append(item + " ");
        }
        return s.toString();
    }

    private boolean check() {
        if (this.N == 0) {
            if (this.first != null) {
                return false;
            }
        } else if (this.N == 1) {
            if (this.first == null) {
                return false;
            }
            if (this.first.next != null) {
                return false;
            }
        } else if (this.first.next == null) {
            return false;
        }
        int numberOfNodes = 0;
        Node x = this.first;
        while (x != null) {
            ++numberOfNodes;
            x = x.next;
        }
        return numberOfNodes == this.N;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ListIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIterator
    implements Iterator<Item> {
        private Node current;

        private ListIterator() {
            this.current = Stack.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }

    private class Node {
        private Item item;
        private Node next;

        private Node() {
        }
    }
}

