/*
 * Decompiled with CFR 0.152.
 */
package smed.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import smed.plug.util.JARFileFilter;

public class SmedFile
extends File {
    private static final long serialVersionUID = 1L;
    private static File plugDir = null;
    private static String pathname = null;
    private static File[] plugJars = null;

    public SmedFile(String pathname) {
        super(pathname);
        SmedFile.pathname = pathname;
        plugDir = new File(pathname);
        plugJars = plugDir.listFiles(new JARFileFilter());
    }

    public boolean needUpdate(File[] jars, String name) {
        for (File j : jars) {
            String jName = j.getName();
            if (jName.length() <= 15 || !jName.substring(16).equals(name.substring(16))) continue;
            if (jName.substring(0, 15).compareTo(name.substring(0, 15)) < 0) {
                j.delete();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isVisible(String name) {
        return this.getAttributeState("visible", name);
    }

    public boolean isDeleted(String name) {
        return this.getAttributeState("deleted", name);
    }

    public boolean getAttributeState(String attribute, String name) {
        File f = SmedFile.getFile(plugJars, name, true);
        if (f == null) {
            return false;
        }
        try {
            JarFile test = new JarFile(pathname + "/.ini/MF" + f.getName().substring(16));
            Manifest mf = test.getManifest();
            String str = mf.getMainAttributes().getValue(attribute);
            if (str == null || !str.equals("yes")) {
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static File getFile(File[] files, String name, Boolean isSmed) {
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            if (!(isSmed != false ? fileName.length() > 15 && fileName.substring(16).equals("_" + name) : fileName.equals(name))) continue;
            return files[i];
        }
        return null;
    }

    public void setVisible(String name, boolean isVisible) {
        this.setAttr("visible", name, isVisible);
    }

    public void setDeleted(String name, boolean isDeleted) {
        this.setAttr("deleted", name, isDeleted);
    }

    private void setAttr(String attribute, String name, boolean b) {
        File f = SmedFile.getFile(plugJars, name, true);
        if (f == null) {
            return;
        }
        try {
            JarFile file = new JarFile(pathname + "/.ini/MF" + f.getName().substring(16));
            Manifest mf = file.getManifest();
            Attributes attr = mf.getMainAttributes();
            if (b) {
                attr.putValue(attribute, "yes");
            } else {
                attr.putValue(attribute, "no");
            }
            FileOutputStream fos = new FileOutputStream(pathname + "/.ini/MF" + f.getName().substring(16));
            JarOutputStream jos = new JarOutputStream((OutputStream)fos, mf);
            jos.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyMFs(File[] plugInis) {
        if (plugJars == null) {
            return;
        }
        for (int i = 0; i < plugJars.length; ++i) {
            String dest;
            String source = plugJars[i].getName();
            if (source.length() <= 15 || SmedFile.getFile(plugInis, dest = "MF" + source.substring(16), false) != null) continue;
            try {
                JarFile file = new JarFile(pathname + "/" + source);
                Manifest mf = file.getManifest();
                Attributes attr = mf.getMainAttributes();
                attr.putValue("visible", "yes");
                attr.putValue("deleted", "no");
                FileOutputStream fos = new FileOutputStream(pathname + "/.ini/" + dest);
                JarOutputStream jos = new JarOutputStream((OutputStream)fos, mf);
                jos.close();
                fos.flush();
                fos.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void init() {
        File splugDirIni = new File(pathname + "/.ini");
        if (!splugDirIni.exists()) {
            splugDirIni.mkdir();
        }
        File[] plugInis = splugDirIni.listFiles(new JARFileFilter());
        SmedFile.copyMFs(plugInis);
        SmedFile smedDir = new SmedFile(pathname);
        for (int i = 0; i < plugJars.length; ++i) {
            String name;
            File file = plugJars[i];
            if (file.getName().length() <= 16 || !smedDir.isDeleted(name = file.getName().substring(17))) continue;
            File fileMF = new File(pathname + "/.ini/MF_" + name);
            fileMF.delete();
            file.delete();
        }
    }

    public static void createMF(String name) {
        if (name.length() > 17) {
            String dest = "MF_" + name.substring(17);
            try {
                JarFile file = new JarFile(pathname + "/" + name);
                Manifest mf = file.getManifest();
                Attributes attr = mf.getMainAttributes();
                attr.putValue("visible", "yes");
                attr.putValue("deleted", "no");
                FileOutputStream fos = new FileOutputStream(pathname + "/.ini/" + dest);
                JarOutputStream jos = new JarOutputStream((OutputStream)fos, mf);
                jos.close();
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

