/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class WikipediaToggleDialog
extends ToggleDialog
implements MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    final StringProperty wikipediaLang = new StringProperty("wikipedia.lang", LanguageInfo.getJOSMLocaleCode().substring(0, 2));
    final Set<String> articles = new HashSet<String>();
    final DefaultListModel model = new DefaultListModel();
    final JList list = new JList(this.model){
        {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && this.getSelectedValue() != null) {
                        WikipediaEntry entry = (WikipediaEntry)this.getSelectedValue();
                        if (entry.coordinate != null) {
                            BoundingXYVisitor bbox = new BoundingXYVisitor();
                            bbox.visit(entry.coordinate);
                            Main.map.mapView.recalculateCenterScale(bbox);
                        }
                        SearchAction.search((String)entry.name.replaceAll("\\(.*\\)", ""), (SearchAction.SearchMode)SearchAction.SearchMode.replace);
                    }
                }
            });
            this.setCellRenderer(new DefaultListCellRenderer(){

                public JLabel getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    WikipediaEntry entry = (WikipediaEntry)value;
                    if (entry.getWiwosmStatus() != null && entry.getWiwosmStatus().booleanValue()) {
                        label.setIcon(ImageProvider.getIfAvailable((String)"misc", (String)"grey_check"));
                        label.setToolTipText(I18n.tr((String)"Available via WIWOSM server", (Object[])new Object[0]));
                    } else if (WikipediaToggleDialog.this.articles.contains(entry.wikipediaArticle)) {
                        label.setIcon(ImageProvider.getIfAvailable((String)"misc", (String)"green_check"));
                        label.setToolTipText(I18n.tr((String)"Available in local dataset", (Object[])new Object[0]));
                    } else {
                        label.setToolTipText(I18n.tr((String)"Not linked yet", (Object[])new Object[0]));
                    }
                    if (entry.description != null) {
                        label.setToolTipText("<html>" + entry.description + "</html>");
                    }
                    return label;
                }
            });
        }
    };
    private final DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter((DataSetListenerAdapter.Listener)this);

    public WikipediaToggleDialog() {
        super(I18n.tr((String)"Wikipedia", (Object[])new Object[0]), "wikipedia", I18n.tr((String)"Fetch Wikipedia articles with coordinates", (Object[])new Object[0]), null, 150);
        this.createLayout(this.list, true, Arrays.asList(new SideButton((Action)new WikipediaLoadCoordinatesAction()), new SideButton((Action)new WikipediaLoadCategoryAction()), new SideButton((Action)new AddWikipediaTagAction()), new SideButton((Action)new OpenWikipediaArticleAction()), new SideButton((Action)new WikipediaSettingsAction(), false)));
        this.setTitle(I18n.tr((String)"{0}.Wikipedia.org", (Object[])new Object[]{this.wikipediaLang.get()}));
    }

    private void setWikipediaEntries(Collection<WikipediaEntry> entries) {
        ArrayList<String> articleNames = new ArrayList<String>();
        for (WikipediaEntry i : entries) {
            articleNames.add(i.wikipediaArticle);
        }
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        if (!articleNames.isEmpty()) {
            String url = "http://toolserver.org/~master/osmjson/getGeoJSON.php?action=check&lang=" + this.wikipediaLang.get() + "&articles=" + WikipediaToggleDialog.encodeURL(Utils.join((String)",", articleNames));
            System.out.println("Wikipedia: GET " + url);
            try {
                Scanner scanner = new Scanner(new URL(url).openStream()).useDelimiter("\n");
                while (scanner.hasNext()) {
                    String line = scanner.next();
                    String[] x = line.split("\t");
                    if (x.length == 2) {
                        status.put(x[0], "1".equals(x[1]));
                        continue;
                    }
                    System.err.println("Unknown element " + line);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.model.clear();
        for (WikipediaEntry i : entries) {
            i.setWiwosmStatus((Boolean)status.get(i.wikipediaArticle));
            this.model.addElement(i);
        }
    }

    protected void updateWikipediaArticles() {
        this.articles.clear();
        if (Main.main != null && Main.main.getCurrentDataSet() != null) {
            for (OsmPrimitive p : Main.main.getCurrentDataSet().allPrimitives()) {
                this.articles.addAll(this.getWikipediaArticles(p));
            }
        }
    }

    protected Collection<String> getWikipediaArticles(OsmPrimitive p) {
        String[] item;
        ArrayList<String> r = new ArrayList<String>();
        Map tags = p.getKeys();
        String wp = (String)tags.get("wikipedia");
        if (wp != null && wp.startsWith("http")) {
            item = WikipediaLangArticle.parseFromUrl(wp);
            if (item != null && this.wikipediaLang.get().equals(item.lang)) {
                r.add(item.article.replace("_", " "));
            }
        } else if (wp != null && (item = WikipediaToggleDialog.decodeURL(wp).split(":", 2)).length == 2 && this.wikipediaLang.get().equals(item[0])) {
            r.add(item[1].replace("_", " "));
        }
        String wpLang = (String)tags.get("wikipedia:" + this.wikipediaLang.get());
        if (wpLang != null && wpLang.startsWith("http")) {
            WikipediaLangArticle item2 = WikipediaLangArticle.parseFromUrl(wpLang);
            if (this.wikipediaLang.get().equals(item2.lang)) {
                r.add(item2.article.replace("_", " "));
            }
        } else if (wpLang != null) {
            String[] item3;
            r.add(item3[(item3 = WikipediaToggleDialog.decodeURL(wpLang).split(":", 2)).length == 2 ? 1 : 0].replace("_", " "));
        }
        return r;
    }

    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        this.updateWikipediaArticles();
    }

    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this.dataChangedAdapter);
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        this.articles.clear();
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        this.updateWikipediaArticles();
        this.list.repaint();
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateWikipediaArticles();
        this.list.repaint();
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    class AddWikipediaTagAction
    extends AbstractAction {
        public AddWikipediaTagAction() {
            super(I18n.tr((String)"Add Tag", (Object[])new Object[0]), ImageProvider.get((String)"pastetags"));
            this.putValue("ShortDescription", I18n.tr((String)"Adds a ''wikipedia'' tag corresponding to this article to the selected objects", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tag tag;
            if (WikipediaToggleDialog.this.list.getSelectedValue() != null && (tag = ((WikipediaEntry)WikipediaToggleDialog.this.list.getSelectedValue()).createWikipediaTag()) != null) {
                ChangePropertyCommand cmd = new ChangePropertyCommand(Main.main.getCurrentDataSet().getSelected(), tag.getKey(), tag.getValue());
                Main.main.undoRedo.add((Command)cmd);
            }
        }
    }

    class WikipediaSettingsAction
    extends AbstractAction {
        public WikipediaSettingsAction() {
            super(I18n.tr((String)"Language", (Object[])new Object[0]), ImageProvider.get((String)"dialogs/settings"));
            this.putValue("ShortDescription", I18n.tr((String)"Sets the default language for the Wikipedia articles", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String lang = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Enter the Wikipedia language", (Object[])new Object[0]), WikipediaToggleDialog.this.wikipediaLang.get());
            if (lang != null) {
                WikipediaToggleDialog.this.wikipediaLang.put(lang);
                WikipediaToggleDialog.this.updateWikipediaArticles();
            }
        }
    }

    class OpenWikipediaArticleAction
    extends AbstractAction {
        public OpenWikipediaArticleAction() {
            super(I18n.tr((String)"Open Article", (Object[])new Object[0]), ImageProvider.getIfAvailable((String)"browser"));
            this.putValue("ShortDescription", I18n.tr((String)"Opens the Wikipedia article of the selected item in a browser", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WikipediaToggleDialog.this.list.getSelectedValue() != null) {
                WikipediaEntry entry = (WikipediaEntry)WikipediaToggleDialog.this.list.getSelectedValue();
                String url = entry.getHrefFromDescription() != null ? entry.getHrefFromDescription() : "http://" + entry.wikipediaLang + ".wikipedia.org/wiki/" + WikipediaToggleDialog.encodeURL(entry.wikipediaArticle.replace(" ", "_"));
                System.out.println("Wikipedia: opening " + url);
                OpenBrowser.displayUrl((String)url);
            }
        }
    }

    class WikipediaLoadCategoryAction
    extends AbstractAction {
        public WikipediaLoadCategoryAction() {
            super(I18n.tr((String)"Category", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"refresh"));
            this.putValue("ShortDescription", I18n.tr((String)"Fetches a list of all Wikipedia articles of a category", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String category = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Enter the Wikipedia category", (Object[])new Object[0]));
                if (category == null) {
                    return;
                }
                String url = "http://toolserver.org/~daniel/WikiSense/CategoryIntersect.php?wikilang=" + WikipediaToggleDialog.this.wikipediaLang.get() + "&wikifam=.wikipedia.org" + "&basecat=" + WikipediaToggleDialog.encodeURL(category) + "&basedeep=3&templates=&mode=al&format=csv";
                System.out.println("Wikipedia: GET " + url);
                Scanner scanner = new Scanner(new URL(url).openStream()).useDelimiter("\n");
                ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>();
                while (scanner.hasNext()) {
                    String article = scanner.next().split("\t")[1].replace("_", " ");
                    entries.add(new WikipediaEntry(article, WikipediaToggleDialog.this.wikipediaLang.get(), article));
                }
                Collections.sort(entries);
                WikipediaToggleDialog.this.setWikipediaEntries(entries);
                WikipediaToggleDialog.this.setTitle(I18n.tr((String)"{0}.Wikipedia.org: {1}", (Object[])new Object[]{WikipediaToggleDialog.this.wikipediaLang.get(), category}));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    class WikipediaLoadCoordinatesAction
    extends AbstractAction {
        public WikipediaLoadCoordinatesAction() {
            super(I18n.tr((String)"Coordinates", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"refresh"));
            this.putValue("ShortDescription", I18n.tr((String)"Fetches all coordinates from Wikipedia in the current view", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                LatLon min = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
                LatLon max = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
                String bbox = min.lon() + "," + min.lat() + "," + max.lon() + "," + max.lat();
                String url = "http://toolserver.org/~kolossos/geoworld/marks.php?bbox=" + bbox + "&LANG=" + WikipediaToggleDialog.this.wikipediaLang.get();
                System.out.println("Wikipedia: GET " + url);
                XPathExpression xpathPlacemark = XPathFactory.newInstance().newXPath().compile("//Placemark");
                XPathExpression xpathName = XPathFactory.newInstance().newXPath().compile("name/text()");
                XPathExpression xpathCoord = XPathFactory.newInstance().newXPath().compile("Point/coordinates/text()");
                XPathExpression xpathDescr = XPathFactory.newInstance().newXPath().compile("description");
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new URL(url).openStream());
                NodeList nodes = (NodeList)xpathPlacemark.evaluate(doc, XPathConstants.NODESET);
                ArrayList<WikipediaEntry> entries = new ArrayList<WikipediaEntry>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String[] coord = xpathCoord.evaluate(nodes.item(i)).split(",");
                    if (coord.length <= 2) continue;
                    String name = xpathName.evaluate(nodes.item(i));
                    String descr = xpathDescr.evaluate(nodes.item(i));
                    entries.add(new WikipediaEntry(name, descr, new LatLon(Double.parseDouble(coord[1]), Double.parseDouble(coord[0]))));
                }
                Collections.sort(entries);
                WikipediaToggleDialog.this.setWikipediaEntries(entries);
                WikipediaToggleDialog.this.setTitle(I18n.tr((String)"{0}.Wikipedia.org: coordinates", (Object[])new Object[]{WikipediaToggleDialog.this.wikipediaLang.get()}));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static class WikipediaEntry
    implements Comparable<WikipediaEntry> {
        final String name;
        final String description;
        final String wikipediaLang;
        final String wikipediaArticle;
        final LatLon coordinate;
        private Boolean wiwosmStatus;

        public WikipediaEntry(String name, String description, LatLon coordinate) {
            this.name = name;
            this.description = description;
            this.coordinate = coordinate;
            WikipediaLangArticle wp = WikipediaLangArticle.parseFromUrl(this.getHrefFromDescription());
            if (wp == null) {
                System.err.println("Could not extract Wikipedia tag from: " + this.getHrefFromDescription());
            }
            this.wikipediaLang = wp == null ? null : wp.lang;
            this.wikipediaArticle = wp == null ? null : wp.article;
        }

        public WikipediaEntry(String name, String wikipediaLang, String wikipediaArticle) {
            this.name = name;
            this.description = null;
            this.wikipediaLang = wikipediaLang;
            this.wikipediaArticle = wikipediaArticle;
            this.coordinate = null;
        }

        protected final String getHrefFromDescription() {
            if (this.description == null) {
                return null;
            }
            Matcher m = Pattern.compile(".*href=\"(.+?)\".*").matcher(this.description);
            if (m.matches()) {
                return m.group(1);
            }
            System.err.println("Could not parse URL from: " + this.description);
            return null;
        }

        protected final Tag createWikipediaTag() {
            return new Tag("wikipedia", this.wikipediaLang + ":" + this.wikipediaArticle);
        }

        private void updateWiwosmStatus() {
            try {
                String url = "http://toolserver.org/~master/osmjson/getGeoJSON.php?action=check&lang=" + this.wikipediaLang + "&article=" + WikipediaToggleDialog.encodeURL(this.wikipediaArticle);
                System.out.println("Wikipedia: GET " + url);
                Scanner scanner = new Scanner(new URL(url).openStream());
                this.wiwosmStatus = scanner.hasNextInt() && scanner.nextInt() == 1;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setWiwosmStatus(Boolean wiwosmStatus) {
            this.wiwosmStatus = wiwosmStatus;
        }

        public Boolean getWiwosmStatus() {
            return this.wiwosmStatus;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(WikipediaEntry o) {
            return this.name.compareTo(o.name);
        }
    }

    static class WikipediaLangArticle {
        final String lang;
        final String article;

        public WikipediaLangArticle(String lang, String article) {
            this.lang = lang;
            this.article = article;
        }

        public static WikipediaLangArticle parseFromUrl(String url) {
            if (url == null) {
                return null;
            }
            url = WikipediaToggleDialog.decodeURL(url);
            Matcher m = Pattern.compile("https?://(\\w*)\\.wikipedia\\.org/wiki/(.*)").matcher(url);
            if (!m.matches()) {
                return null;
            }
            return new WikipediaLangArticle(m.group(1), m.group(2));
        }
    }
}

