/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.AbstractSet;
import java.util.Iterator;
import org.geotools.resources.XArray;

public final class LazySet<E>
extends AbstractSet<E> {
    private final Iterator<? extends E> iterator;
    private E[] elements;
    private int size;

    public LazySet(Iterator<? extends E> iterator) {
        this.iterator = iterator;
        this.elements = new Object[4];
    }

    private void addNext() {
        if (this.size >= this.elements.length) {
            this.elements = XArray.resize(this.elements, this.size * 2);
        }
        this.elements[this.size++] = this.iterator.next();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter();
    }

    @Override
    public int size() {
        while (this.iterator.hasNext()) {
            this.addNext();
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0 && !this.iterator.hasNext();
    }

    final boolean exists(int n) {
        return n < this.size || this.iterator.hasNext();
    }

    public E get(int n) {
        while (n >= this.size) {
            if (!this.iterator.hasNext()) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            this.addNext();
        }
        return this.elements[n];
    }

    private final class Iter
    implements Iterator<E> {
        private int cursor;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return LazySet.this.exists(this.cursor);
        }

        @Override
        public E next() {
            return LazySet.this.get(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

