/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.Date;
import org.geotools.resources.XArray;

public abstract class ClassChanger<S extends Comparable<S>, T extends Number> {
    private static ClassChanger<?, ?>[] changers = new ClassChanger[]{new ClassChanger<Date, Long>(Date.class, Long.class){

        @Override
        protected Long convert(Date date) {
            return date.getTime();
        }

        @Override
        protected Date inverseConvert(Long l) {
            return new Date(l);
        }
    }};
    private final Class<S> source;
    private final Class<T> target;

    protected ClassChanger(Class<S> clazz, Class<T> clazz2) {
        this.source = clazz;
        this.target = clazz2;
        if (!Comparable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.valueOf(clazz));
        }
        if (!Number.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(String.valueOf(clazz2));
        }
    }

    protected abstract T convert(S var1) throws ClassCastException;

    protected abstract S inverseConvert(T var1);

    public String toString() {
        return "ClassChanger[" + this.source.getName() + "\u00a0\u21e8\u00a0" + this.target.getName() + ']';
    }

    public static synchronized void register(ClassChanger<?, ?> classChanger) throws IllegalStateException {
        int n;
        for (n = 0; n < changers.length; ++n) {
            if (!ClassChanger.changers[n].source.isAssignableFrom(classChanger.source)) continue;
            for (int i = n; i < changers.length; ++i) {
                if (!ClassChanger.changers[i].source.equals(classChanger.source)) continue;
                throw new IllegalStateException(changers[i].toString());
            }
            break;
        }
        changers = XArray.insert(changers, n, 1);
        ClassChanger.changers[n] = classChanger;
    }
}

