/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import javax.measure.unit.NonSI;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.SingularMatrixException;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.MatrixParameterDescriptors;
import org.geotools.parameter.MatrixParameters;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.operation.transform.ProjectiveTransform2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class ProjectiveTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -2104496465933824935L;
    private final int numRow;
    private final int numCol;
    private final double[] elt;
    private transient ProjectiveTransform inverse;

    protected ProjectiveTransform(Matrix matrix) {
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        this.elt = new double[this.numRow * this.numCol];
        int n = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                this.elt[n++] = matrix.getElement(i, j);
            }
        }
    }

    public static LinearTransform create(Matrix matrix) {
        int n = matrix.getNumRow() - 1;
        if (n == matrix.getNumCol() - 1) {
            if (matrix.isIdentity()) {
                return IdentityTransform.create(n);
            }
            GeneralMatrix generalMatrix = ProjectiveTransform.toGMatrix(matrix);
            if (generalMatrix.isAffine()) {
                switch (n) {
                    case 1: {
                        return LinearTransform1D.create(generalMatrix.getElement(0, 0), generalMatrix.getElement(0, 1));
                    }
                    case 2: {
                        return ProjectiveTransform.create(generalMatrix.toAffineTransform2D());
                    }
                }
            }
        }
        switch (n) {
            case 2: {
                return new ProjectiveTransform2D(matrix);
            }
        }
        return new ProjectiveTransform(matrix);
    }

    public static LinearTransform create(AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return IdentityTransform.create(2);
        }
        return new AffineTransform2D(affineTransform);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return ProviderAffine.PARAMETERS;
    }

    static ParameterValueGroup getParameterValues(Matrix matrix) {
        MatrixParameters matrixParameters = (MatrixParameters)ProviderAffine.PARAMETERS.createValue();
        matrixParameters.setMatrix(matrix);
        return matrixParameters;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        int n5 = this.numCol - 1;
        int n6 = this.numRow - 1;
        double[] dArray = new double[this.numRow];
        if (fArray == fArray2 && (n4 = n + n3 * n5) > n2 && (n5 >= n6 ? n2 > n : n2 + n3 * n6 > n4)) {
            fArray = new float[n3 * n5];
            System.arraycopy(fArray2, n, fArray, 0, fArray.length);
            n = 0;
        }
        while (--n3 >= 0) {
            n4 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n4 + n5];
                for (int j = 0; j < n5; ++j) {
                    d += (double)fArray[n + j] * this.elt[n4++];
                }
                dArray[i] = d;
                ++n4;
            }
            double d = dArray[n6];
            for (int i = 0; i < n6; ++i) {
                fArray2[n2++] = (float)(dArray[i] / d);
            }
            n += n5;
        }
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        int n5 = this.numCol - 1;
        int n6 = this.numRow - 1;
        double[] dArray3 = new double[this.numRow];
        if (dArray == dArray2 && (n4 = n + n3 * n5) > n2 && (n5 >= n6 ? n2 > n : n2 + n3 * n6 > n4)) {
            dArray = new double[n3 * n5];
            System.arraycopy(dArray2, n, dArray, 0, dArray.length);
            n = 0;
        }
        while (--n3 >= 0) {
            n4 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n4 + n5];
                for (int j = 0; j < n5; ++j) {
                    d += dArray[n + j] * this.elt[n4++];
                }
                dArray3[i] = d;
                ++n4;
            }
            double d = dArray3[n6];
            for (int i = 0; i < n6; ++i) {
                dArray2[n2++] = dArray3[i] / d;
            }
            n += n5;
        }
    }

    @Override
    public Matrix derivative(Point2D point2D) {
        return this.derivative((DirectPosition)null);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        GeneralMatrix generalMatrix = this.getGeneralMatrix();
        generalMatrix.setSize(this.numRow - 1, this.numCol - 1);
        return generalMatrix;
    }

    @Override
    public Matrix getMatrix() {
        return this.getGeneralMatrix();
    }

    private GeneralMatrix getGeneralMatrix() {
        return new GeneralMatrix(this.numRow, this.numCol, this.elt);
    }

    @Override
    public int getSourceDimensions() {
        return this.numCol - 1;
    }

    @Override
    public int getTargetDimensions() {
        return this.numRow - 1;
    }

    @Override
    public boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                if (this.elt[n++] == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        assert (this.isIdentity(0.0));
        return true;
    }

    @Override
    public boolean isIdentity(double d) {
        d = Math.abs(d);
        if (this.numRow != this.numCol) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                double d2 = this.elt[n++];
                if (j == i) {
                    d2 -= 1.0;
                }
                if (Math.abs(d2) <= d) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                GeneralMatrix generalMatrix = this.getGeneralMatrix();
                try {
                    generalMatrix.invert();
                }
                catch (SingularMatrixException singularMatrixException) {
                    throw new NoninvertibleTransformException(Errors.format(105), singularMatrixException);
                }
                catch (MismatchedSizeException mismatchedSizeException) {
                    throw new NoninvertibleTransformException(Errors.format(105), mismatchedSizeException);
                }
                this.inverse = new ProjectiveTransform(generalMatrix);
                this.inverse.inverse = this;
            }
        }
        return this.inverse;
    }

    MathTransform createInverse(Matrix matrix) {
        return new ProjectiveTransform(matrix);
    }

    @Override
    public int hashCode() {
        long l = -2104496465933824935L;
        int n = this.elt.length;
        while (--n >= 0) {
            l = l * 37L + Double.doubleToLongBits(this.elt[n]);
        }
        return (int)(l >>> 32) ^ (int)l;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ProjectiveTransform projectiveTransform = (ProjectiveTransform)object;
            return this.numRow == projectiveTransform.numRow && this.numCol == projectiveTransform.numCol && Arrays.equals(this.elt, projectiveTransform.elt);
        }
        return false;
    }

    public static final class ProviderLongitudeRotation
    extends MathTransformProvider {
        private static final long serialVersionUID = -2104496465933824935L;
        public static final ParameterDescriptor OFFSET = ProviderLongitudeRotation.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Longitude offset")}, Double.NaN, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = ProviderLongitudeRotation.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Longitude rotation"), new NamedIdentifier(Citations.EPSG, "9601")}, new ParameterDescriptor[]{OFFSET});

        public ProviderLongitudeRotation() {
            super(2, 2, PARAMETERS);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            double d = ProviderLongitudeRotation.doubleValue(OFFSET, parameterValueGroup);
            return ProjectiveTransform.create(AffineTransform.getTranslateInstance(d, 0.0));
        }
    }

    public static final class ProviderAffine
    extends MathTransformProvider {
        private static final long serialVersionUID = 649555815622129472L;
        private static final ProviderAffine[] methods = new ProviderAffine[8];
        static final ParameterDescriptorGroup PARAMETERS;

        public ProviderAffine() {
            this(2, 2);
            ProviderAffine.methods[1] = this;
        }

        private ProviderAffine(int n, int n2) {
            super(n, n2, PARAMETERS);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            LinearTransform linearTransform = ProjectiveTransform.create(((MatrixParameterDescriptors)this.getParameters()).getMatrix(parameterValueGroup));
            return new MathTransformProvider.Delegate(linearTransform, ProviderAffine.getProvider(linearTransform.getSourceDimensions(), linearTransform.getTargetDimensions()));
        }

        public static ProviderAffine getProvider(int n, int n2) {
            int n3;
            if (n == n2 && (n3 = n - 1) >= 0 && n3 < methods.length) {
                ProviderAffine providerAffine = methods[n3];
                if (providerAffine == null) {
                    ProviderAffine.methods[n3] = providerAffine = new ProviderAffine(n, n2);
                }
                return providerAffine;
            }
            return new ProviderAffine(n, n2);
        }

        static {
            NamedIdentifier namedIdentifier = new NamedIdentifier(Citations.OGC, "Affine");
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4, 0.8f);
            hashMap.put("name", namedIdentifier);
            hashMap.put("identifiers", namedIdentifier);
            hashMap.put("alias", new NamedIdentifier[]{namedIdentifier, new NamedIdentifier(Citations.EPSG, "Affine general parametric transformation"), new NamedIdentifier(Citations.EPSG, "9624"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(2))});
            PARAMETERS = new MatrixParameterDescriptors(hashMap);
        }
    }
}

