/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.util.Collections;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.GeocentricTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Transformation;

public class GeocentricTranslation
extends ProjectiveTransform {
    private static final long serialVersionUID = -168669443433018655L;
    private final ParameterDescriptorGroup descriptor;

    GeocentricTranslation(BursaWolfParameters bursaWolfParameters, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(bursaWolfParameters.getAffineTransform());
        this.descriptor = parameterDescriptorGroup;
    }

    private GeocentricTranslation(Matrix matrix, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(matrix);
        this.descriptor = parameterDescriptorGroup;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptor;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        boolean bl;
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(null);
        bursaWolfParameters.setAffineTransform(this.getMatrix(), Double.POSITIVE_INFINITY);
        if (ProviderFrameRotation.PARAMETERS.equals(this.descriptor)) {
            bursaWolfParameters.ex = -bursaWolfParameters.ex;
            bursaWolfParameters.ey = -bursaWolfParameters.ey;
            bursaWolfParameters.ez = -bursaWolfParameters.ez;
        }
        GeneralParameterValue[] generalParameterValueArray = new FloatParameter[(bl = Provider.PARAMETERS.equals(this.descriptor)) ? 3 : 7];
        generalParameterValueArray[0] = new FloatParameter(Provider.DX, bursaWolfParameters.dx);
        generalParameterValueArray[1] = new FloatParameter(Provider.DY, bursaWolfParameters.dy);
        generalParameterValueArray[2] = new FloatParameter(Provider.DZ, bursaWolfParameters.dz);
        if (!bl) {
            generalParameterValueArray[3] = new FloatParameter(ProviderSevenParam.EX, bursaWolfParameters.ex);
            generalParameterValueArray[4] = new FloatParameter(ProviderSevenParam.EY, bursaWolfParameters.ey);
            generalParameterValueArray[5] = new FloatParameter(ProviderSevenParam.EZ, bursaWolfParameters.ez);
            generalParameterValueArray[6] = new FloatParameter(ProviderSevenParam.PPM, bursaWolfParameters.ppm);
        }
        return new ParameterGroup(this.getParameterDescriptors(), generalParameterValueArray);
    }

    @Override
    MathTransform createInverse(Matrix matrix) {
        return new GeocentricTranslation(matrix, this.descriptor);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.descriptor.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            GeocentricTranslation geocentricTranslation = (GeocentricTranslation)object;
            return Utilities.equals(this.descriptor, geocentricTranslation.descriptor);
        }
        return false;
    }

    public static class ProviderFrameRotation
    extends ProviderSevenParam {
        private static final long serialVersionUID = 5513675854809530038L;
        static final ParameterDescriptorGroup PARAMETERS = ProviderFrameRotation.createDescriptorGroup("Coordinate Frame Rotation (geog2D domain)", "9607");

        public ProviderFrameRotation() {
            super(PARAMETERS);
        }

        @Override
        protected void fill(BursaWolfParameters bursaWolfParameters, ParameterValueGroup parameterValueGroup) {
            super.fill(bursaWolfParameters, parameterValueGroup);
            bursaWolfParameters.ex = -bursaWolfParameters.ex;
            bursaWolfParameters.ey = -bursaWolfParameters.ey;
            bursaWolfParameters.ez = -bursaWolfParameters.ez;
        }
    }

    public static class ProviderSevenParam
    extends Provider {
        private static final long serialVersionUID = -6398226638364450229L;
        private static final double MAX_ROTATION = 648000.0;
        public static final ParameterDescriptor EX = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ex"), new NamedIdentifier(Citations.EPSG, "X-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
        public static final ParameterDescriptor EY = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ey"), new NamedIdentifier(Citations.EPSG, "Y-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
        public static final ParameterDescriptor EZ = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ez"), new NamedIdentifier(Citations.EPSG, "Z-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
        public static final ParameterDescriptor PPM = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ppm"), new NamedIdentifier(Citations.EPSG, "Scale difference")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Units.PPM);
        static final ParameterDescriptorGroup PARAMETERS = ProviderSevenParam.createDescriptorGroup("Position Vector transformation (geog2D domain)", "9606");

        static ParameterDescriptorGroup createDescriptorGroup(String string, String string2) {
            return ProviderSevenParam.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, string), new NamedIdentifier(Citations.EPSG, string2)}, new ParameterDescriptor[]{DX, DY, DZ, EX, EY, EZ, PPM, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, SRC_DIM, TGT_DIM});
        }

        public ProviderSevenParam() {
            super(PARAMETERS);
        }

        ProviderSevenParam(ParameterDescriptorGroup parameterDescriptorGroup) {
            super(parameterDescriptorGroup);
        }

        @Override
        protected void fill(BursaWolfParameters bursaWolfParameters, ParameterValueGroup parameterValueGroup) {
            super.fill(bursaWolfParameters, parameterValueGroup);
            bursaWolfParameters.ppm = ProviderSevenParam.doubleValue(PPM, parameterValueGroup);
            bursaWolfParameters.ex = ProviderSevenParam.doubleValue(EX, parameterValueGroup);
            bursaWolfParameters.ey = ProviderSevenParam.doubleValue(EY, parameterValueGroup);
            bursaWolfParameters.ez = ProviderSevenParam.doubleValue(EZ, parameterValueGroup);
        }
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -7160250630666911608L;
        static final int DEFAULT_DIMENSION = 2;
        public static final ParameterDescriptor<Integer> SRC_DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLS, "src_dim")), 2, 2, 3, false);
        public static final ParameterDescriptor<Integer> TGT_DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLS, "tgt_dim")), 2, 2, 3, false);
        public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "src_semi_major")}, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> SRC_SEMI_MINOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "src_semi_minor")}, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "tgt_semi_major")}, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> TGT_SEMI_MINOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "tgt_semi_minor")}, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> DX = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dx"), new NamedIdentifier(Citations.EPSG, "X-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> DY = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dy"), new NamedIdentifier(Citations.EPSG, "Y-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> DZ = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dz"), new NamedIdentifier(Citations.EPSG, "Z-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METER);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Geocentric translations (geog2D domain)"), new NamedIdentifier(Citations.EPSG, "9603")}, new ParameterDescriptor[]{DX, DY, DZ, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, SRC_DIM, TGT_DIM});

        public Provider() {
            this(PARAMETERS);
        }

        Provider(ParameterDescriptorGroup parameterDescriptorGroup) {
            super(3, 3, parameterDescriptorGroup);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(null);
            this.fill(bursaWolfParameters, parameterValueGroup);
            return Provider.concatenate(Provider.concatenate(new GeocentricTranslation(bursaWolfParameters, this.getParameters()), parameterValueGroup, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, SRC_DIM), parameterValueGroup, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, TGT_DIM);
        }

        protected void fill(BursaWolfParameters bursaWolfParameters, ParameterValueGroup parameterValueGroup) {
            bursaWolfParameters.dx = Provider.doubleValue(DX, parameterValueGroup);
            bursaWolfParameters.dy = Provider.doubleValue(DY, parameterValueGroup);
            bursaWolfParameters.dz = Provider.doubleValue(DZ, parameterValueGroup);
        }

        private static MathTransform concatenate(MathTransform mathTransform, ParameterValueGroup parameterValueGroup, ParameterDescriptor parameterDescriptor, ParameterDescriptor parameterDescriptor2, ParameterDescriptor parameterDescriptor3) {
            double d = Provider.doubleValue(parameterDescriptor, parameterValueGroup);
            double d2 = Provider.doubleValue(parameterDescriptor2, parameterValueGroup);
            int n = Provider.intValue(parameterDescriptor3, parameterValueGroup);
            switch (n) {
                case 0: {
                    if (Double.isNaN(d) && Double.isNaN(d2)) {
                        return mathTransform;
                    }
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format(58, parameterDescriptor3.getName().getCode(), n));
                }
            }
            Provider.ensureValid(parameterDescriptor, d);
            Provider.ensureValid(parameterDescriptor2, d2);
            GeocentricTransform geocentricTransform = new GeocentricTransform(d, d2, SI.METER, n == 3);
            if (parameterDescriptor3 == SRC_DIM) {
                return ConcatenatedTransform.create(geocentricTransform, mathTransform);
            }
            return ConcatenatedTransform.create(mathTransform, geocentricTransform.inverse());
        }

        private static void ensureValid(ParameterDescriptor parameterDescriptor, double d) {
            if (!(d > 0.0)) {
                throw new IllegalStateException(Errors.format(99, parameterDescriptor.getName().getCode()));
            }
        }
    }
}

