/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import javax.measure.converter.ConversionException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.LazySet;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CanonicalSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class DefaultMathTransformFactory
extends ReferencingFactory
implements MathTransformFactory {
    private static final Hints HINTS = null;
    private transient MathTransformProvider lastProvider;
    private static final ThreadLocal<OperationMethod> lastMethod = new ThreadLocal();
    private final CanonicalSet<MathTransform> pool;
    private final FactoryRegistry registry;

    public DefaultMathTransformFactory() {
        this(new Class[]{MathTransformProvider.class});
    }

    private DefaultMathTransformFactory(Class<?>[] classArray) {
        this.registry = new FactoryRegistry(Arrays.asList(classArray));
        this.pool = CanonicalSet.newInstance(MathTransform.class);
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    @Override
    public Set<OperationMethod> getAvailableMethods(Class<? extends Operation> clazz) {
        return new LazySet<OperationMethod>(this.registry.getServiceProviders(MathTransformProvider.class, (ServiceRegistry.Filter)(clazz != null ? new MethodFilter(clazz) : null), HINTS));
    }

    @Override
    public OperationMethod getLastMethodUsed() {
        return lastMethod.get();
    }

    private MathTransformProvider getProvider(String string) throws NoSuchIdentifierException {
        MathTransformProvider mathTransformProvider = this.lastProvider;
        if (mathTransformProvider != null && mathTransformProvider.nameMatches(string)) {
            return mathTransformProvider;
        }
        Iterator<MathTransformProvider> iterator = this.registry.getServiceProviders(MathTransformProvider.class, null, HINTS);
        while (iterator.hasNext()) {
            mathTransformProvider = iterator.next();
            if (!mathTransformProvider.nameMatches(string)) continue;
            this.lastProvider = mathTransformProvider;
            return this.lastProvider;
        }
        throw new NoSuchIdentifierException(Errors.format(141, string), string);
    }

    @Override
    public ParameterValueGroup getDefaultParameters(String string) throws NoSuchIdentifierException {
        return this.getProvider(string).getParameters().createValue();
    }

    @Override
    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, ParameterValueGroup parameterValueGroup, CoordinateSystem coordinateSystem) throws NoSuchIdentifierException, FactoryException {
        Object object;
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(coordinateReferenceSystem);
        if (ellipsoid != null) {
            object = ellipsoid.getAxisUnit();
            Parameters.ensureSet(parameterValueGroup, "semi_major", ellipsoid.getSemiMajorAxis(), object, false);
            Parameters.ensureSet(parameterValueGroup, "semi_minor", ellipsoid.getSemiMinorAxis(), object, false);
        }
        object = this.createParameterizedTransform(parameterValueGroup);
        OperationMethod operationMethod = lastMethod.get();
        object = this.createBaseToDerived(coordinateReferenceSystem, (MathTransform)object, coordinateSystem);
        lastMethod.set(operationMethod);
        return object;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws FactoryException {
        int n;
        int n2;
        Matrix matrix;
        Matrix matrix2;
        CoordinateSystem coordinateSystem2 = coordinateReferenceSystem.getCoordinateSystem();
        try {
            matrix2 = AbstractCS.swapAndScaleAxis(coordinateSystem2, AbstractCS.standard(coordinateSystem2));
            matrix = AbstractCS.swapAndScaleAxis(AbstractCS.standard(coordinateSystem), coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            throw new FactoryException(conversionException);
        }
        MathTransform mathTransform2 = this.createAffineTransform(matrix2);
        MathTransform mathTransform3 = this.createAffineTransform(matrix);
        MathTransform mathTransform4 = mathTransform;
        int n3 = mathTransform3.getSourceDimensions() - mathTransform4.getTargetDimensions();
        if (n3 > 0) {
            mathTransform4 = this.createPassThroughTransform(0, mathTransform4, n3);
        }
        if ((n2 = mathTransform2.getTargetDimensions()) > (n = mathTransform4.getSourceDimensions())) {
            XMatrix xMatrix = MatrixFactory.create(n + 1, n2 + 1);
            xMatrix.setElement(n, n2, 1.0);
            mathTransform2 = this.createConcatenatedTransform(this.createAffineTransform(xMatrix), mathTransform2);
        }
        return this.createConcatenatedTransform(this.createConcatenatedTransform(mathTransform2, mathTransform4), mathTransform3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform createParameterizedTransform(ParameterValueGroup parameterValueGroup) throws NoSuchIdentifierException, FactoryException {
        MathTransform mathTransform;
        OperationMethod operationMethod = null;
        try {
            MathTransformProvider mathTransformProvider;
            String string = parameterValueGroup.getDescriptor().getName().getCode();
            operationMethod = mathTransformProvider = this.getProvider(string);
            try {
                parameterValueGroup = mathTransformProvider.ensureValidValues(parameterValueGroup);
                mathTransform = mathTransformProvider.createMathTransform(parameterValueGroup);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FactoryException(illegalArgumentException);
            }
            if (mathTransform instanceof MathTransformProvider.Delegate) {
                MathTransformProvider.Delegate delegate = (MathTransformProvider.Delegate)mathTransform;
                operationMethod = delegate.method;
                mathTransform = delegate.transform;
            }
            mathTransform = this.pool.unique(mathTransform);
            lastMethod.set(operationMethod);
        }
        catch (Throwable throwable) {
            lastMethod.set(operationMethod);
            throw throwable;
        }
        return mathTransform;
    }

    @Override
    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        lastMethod.remove();
        return this.pool.unique(ProjectiveTransform.create(matrix));
    }

    @Override
    public MathTransform createConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        MathTransform mathTransform3;
        try {
            mathTransform3 = ConcatenatedTransform.create(mathTransform, mathTransform2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        mathTransform3 = this.pool.unique(mathTransform3);
        return mathTransform3;
    }

    @Override
    public MathTransform createPassThroughTransform(int n, MathTransform mathTransform, int n2) throws FactoryException {
        MathTransform mathTransform2;
        try {
            mathTransform2 = PassThroughTransform.create(n, mathTransform, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        mathTransform2 = this.pool.unique(mathTransform2);
        return mathTransform2;
    }

    private static final class MethodFilter
    implements ServiceRegistry.Filter {
        private final Class<? extends Operation> type;

        public MethodFilter(Class<? extends Operation> clazz) {
            this.type = clazz;
        }

        @Override
        public boolean filter(Object object) {
            Class<? extends Operation> clazz;
            return !(object instanceof MathTransformProvider) || (clazz = ((MathTransformProvider)object).getOperationType()) == null || this.type.isAssignableFrom(clazz);
        }
    }
}

