/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;
    public static DefaultEllipsoidalCS GEODETIC_2D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(83), DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
    public static DefaultEllipsoidalCS GEODETIC_3D = new DefaultEllipsoidalCS(DefaultEllipsoidalCS.name(84), DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, new CoordinateSystemAxis[]{coordinateSystemAxis, coordinateSystemAxis2});
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, new CoordinateSystemAxis[]{coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3});
    }

    private DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.NORTH.equals(axisDirection = axisDirection.absolute()) || AxisDirection.EAST.equals(axisDirection) || AxisDirection.UP.equals(axisDirection);
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        Unit<Quantity> unit2 = AxisDirection.UP.equals(axisDirection = axisDirection.absolute()) ? SI.METER : NonSI.DEGREE_ANGLE;
        return unit2.isCompatible(unit);
    }
}

