/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.InternationalString;

public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    protected final CoordinateSystem coordinateSystem;

    public AbstractCRS(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        super(map);
        AbstractCRS.ensureNonNull("cs", coordinateSystem);
        this.coordinateSystem = coordinateSystem;
    }

    static Map<String, ?> name(int n) {
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>(4);
        InternationalString internationalString = Vocabulary.formatInternational(n);
        hashMap.put("name", ((Object)internationalString).toString());
        hashMap.put("alias", internationalString);
        return hashMap;
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (super.equals(abstractIdentifiedObject, bl)) {
            AbstractCRS abstractCRS = (AbstractCRS)abstractIdentifiedObject;
            return AbstractCRS.equals(this.coordinateSystem, abstractCRS.coordinateSystem, bl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x3D90441 ^ this.coordinateSystem.hashCode();
    }
}

