/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.geotools.referencing.factory.ThreadedAuthorityFactory;
import org.geotools.resources.UnmodifiableArrayList;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class DefaultAuthorityFactory
extends ThreadedAuthorityFactory
implements CRSAuthorityFactory {
    private static List<String> AUTHORITY_LESS = UnmodifiableArrayList.wrap(new String[]{"WGS84(DD)"});

    DefaultAuthorityFactory(boolean bl) {
        super(DefaultAuthorityFactory.getBackingFactory(bl));
    }

    private static AbstractAuthorityFactory getBackingFactory(boolean bl) {
        Hints hints = GeoTools.getDefaultHints();
        if (bl) {
            hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        }
        Collection<CRSAuthorityFactory> collection = ReferencingFactoryFinder.getCRSAuthorityFactories(hints);
        if (Boolean.TRUE.equals(hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE))) {
            collection = new ArrayList<CRSAuthorityFactory>(collection);
            LinkedHashSet<Citation> linkedHashSet = new LinkedHashSet<Citation>();
            for (CRSAuthorityFactory cRSAuthorityFactory : collection) {
                linkedHashSet.add(cRSAuthorityFactory.getAuthority());
            }
            block1: for (CRSAuthorityFactory cRSAuthorityFactory : ReferencingFactoryFinder.getCRSAuthorityFactories(hints)) {
                Citation citation = cRSAuthorityFactory.getAuthority();
                if (linkedHashSet.contains(citation)) continue;
                for (Citation citation2 : linkedHashSet) {
                    if (!Citations.identifierMatches(citation, citation2)) continue;
                    continue block1;
                }
                collection.add(cRSAuthorityFactory);
            }
        }
        return new ManyAuthoritiesFactory(collection);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        if (string != null && (string = string.trim()).equalsIgnoreCase("WGS84(DD)")) {
            return DefaultGeographicCRS.WGS84;
        }
        assert (!AUTHORITY_LESS.contains(string)) : string;
        return super.createCoordinateReferenceSystem(string);
    }
}

