/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.citation.ContactImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public class ResponsiblePartyImpl
extends MetadataEntity
implements ResponsibleParty {
    private static final long serialVersionUID = -2477962229031486552L;
    static final InternationalString OGC_NAME = new SimpleInternationalString("Open Geospatial Consortium");
    public static ResponsibleParty OGC;
    public static ResponsibleParty OPEN_GIS;
    public static ResponsibleParty EPSG;
    public static ResponsibleParty GEOTIFF;
    public static ResponsibleParty ESRI;
    public static ResponsibleParty ORACLE;
    public static ResponsibleParty SUN_MICROSYSTEMS;
    public static ResponsibleParty GEOTOOLS;
    private String individualName;
    private InternationalString organisationName;
    private InternationalString positionName;
    private Contact contactInfo;
    private Role role;

    public static ResponsibleParty OGC(Role role, OnLineResource onLineResource) {
        ContactImpl contactImpl = new ContactImpl(onLineResource);
        contactImpl.freeze();
        ResponsiblePartyImpl responsiblePartyImpl = new ResponsiblePartyImpl(role);
        responsiblePartyImpl.setOrganisationName(OGC_NAME);
        responsiblePartyImpl.setContactInfo(contactImpl);
        responsiblePartyImpl.freeze();
        return responsiblePartyImpl;
    }

    public static ResponsibleParty OGC(Role role, OnLineFunction onLineFunction, URI uRI) {
        OnLineResourceImpl onLineResourceImpl = new OnLineResourceImpl(uRI);
        onLineResourceImpl.setFunction(onLineFunction);
        onLineResourceImpl.freeze();
        return ResponsiblePartyImpl.OGC(role, onLineResourceImpl);
    }

    static ResponsibleParty OGC(Role role, OnLineFunction onLineFunction, String string) {
        try {
            return ResponsiblePartyImpl.OGC(role, onLineFunction, new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.unexpectedException("org.geotools.metadata.iso", ResponsibleParty.class, "OGC", (Throwable)uRISyntaxException);
            return OGC;
        }
    }

    public ResponsiblePartyImpl() {
    }

    public ResponsiblePartyImpl(Role role) {
        this.setRole(role);
    }

    @Override
    public String getIndividualName() {
        return this.individualName;
    }

    public synchronized void setIndividualName(String string) {
        this.checkWritePermission();
        this.individualName = string;
    }

    @Override
    public InternationalString getOrganisationName() {
        return this.organisationName;
    }

    public synchronized void setOrganisationName(InternationalString internationalString) {
        this.checkWritePermission();
        this.organisationName = internationalString;
    }

    @Override
    public InternationalString getPositionName() {
        return this.positionName;
    }

    public synchronized void setPositionName(InternationalString internationalString) {
        this.checkWritePermission();
        this.positionName = internationalString;
    }

    public Contact getContactInfo() {
        return this.contactInfo;
    }

    public synchronized void setContactInfo(Contact contact) {
        this.checkWritePermission();
        this.contactInfo = contact;
    }

    public Role getRole() {
        return this.role;
    }

    public synchronized void setRole(Role role) {
        this.checkWritePermission();
        this.role = role;
    }

    static {
        ResponsiblePartyImpl responsiblePartyImpl = new ResponsiblePartyImpl(Role.RESOURCE_PROVIDER);
        responsiblePartyImpl.setOrganisationName(OGC_NAME);
        responsiblePartyImpl.setContactInfo(ContactImpl.OGC);
        responsiblePartyImpl.freeze();
        OGC = responsiblePartyImpl;
        responsiblePartyImpl = new ResponsiblePartyImpl(Role.RESOURCE_PROVIDER);
        responsiblePartyImpl.setOrganisationName(new SimpleInternationalString("OpenGIS consortium"));
        responsiblePartyImpl.setContactInfo(ContactImpl.OPEN_GIS);
        responsiblePartyImpl.freeze();
        OPEN_GIS = responsiblePartyImpl;
        responsiblePartyImpl = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        responsiblePartyImpl.setOrganisationName(new SimpleInternationalString("European Petroleum Survey Group"));
        responsiblePartyImpl.setContactInfo(ContactImpl.EPSG);
        responsiblePartyImpl.freeze();
        EPSG = responsiblePartyImpl;
        responsiblePartyImpl = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        responsiblePartyImpl.setOrganisationName(new SimpleInternationalString("GeoTIFF"));
        responsiblePartyImpl.setContactInfo(ContactImpl.GEOTIFF);
        responsiblePartyImpl.freeze();
        GEOTIFF = responsiblePartyImpl;
        responsiblePartyImpl = new ResponsiblePartyImpl(Role.OWNER);
        responsiblePartyImpl.setOrganisationName(new SimpleInternationalString("ESRI"));
        responsiblePartyImpl.setContactInfo(ContactImpl.ESRI);
        responsiblePartyImpl.freeze();
        ESRI = responsiblePartyImpl;
        responsiblePartyImpl = new ResponsiblePartyImpl(Role.OWNER);
        responsiblePartyImpl.setOrganisationName(new SimpleInternationalString("Oracle"));
        responsiblePartyImpl.setContactInfo(ContactImpl.ORACLE);
        responsiblePartyImpl.freeze();
        ORACLE = responsiblePartyImpl;
        responsiblePartyImpl = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        responsiblePartyImpl.setOrganisationName(new SimpleInternationalString("Sun Microsystems"));
        responsiblePartyImpl.setContactInfo(ContactImpl.SUN_MICROSYSTEMS);
        responsiblePartyImpl.freeze();
        SUN_MICROSYSTEMS = responsiblePartyImpl;
        responsiblePartyImpl = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        responsiblePartyImpl.setOrganisationName(new SimpleInternationalString("Geotools"));
        responsiblePartyImpl.setContactInfo(ContactImpl.GEOTOOLS);
        responsiblePartyImpl.freeze();
        GEOTOOLS = responsiblePartyImpl;
    }
}

