/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.geotools.util.Utilities;

public class ExpandedTabWriter
extends FilterWriter {
    private int tabWidth = 8;
    private int column = 0;

    public ExpandedTabWriter(Writer writer) {
        super(writer);
    }

    private void expand() throws IOException {
        int n = this.tabWidth - this.column % this.tabWidth;
        this.out.write(Utilities.spaces(n));
        this.column += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            switch (n) {
                case 10: 
                case 13: {
                    this.column = 0;
                    break;
                }
                case 9: {
                    this.expand();
                    return;
                }
                default: {
                    ++this.column;
                }
            }
            this.out.write(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3 = n;
            n2 += n;
            block7: for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.column = 0;
                        continue block7;
                    }
                    case '\t': {
                        this.out.write(cArray, n3, i - n3);
                        n3 = i + 1;
                        this.expand();
                        continue block7;
                    }
                    default: {
                        ++this.column;
                    }
                }
            }
            this.out.write(cArray, n3, n2 - n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3 = n;
            n2 += n;
            block7: for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.column = 0;
                        continue block7;
                    }
                    case '\t': {
                        this.out.write(string, n3, i - n3);
                        n3 = i + 1;
                        this.expand();
                        continue block7;
                    }
                    default: {
                        ++this.column;
                    }
                }
            }
            this.out.write(string, n3, n2 - n3);
        }
    }
}

