/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.geotools.index.quadtree.StoreException;
import org.geotools.util.logging.Logging;

public class IndexHeader {
    public static final byte LSB_ORDER = -1;
    public static final byte MSB_ORDER = -2;
    public static final byte NATIVE_ORDER = 0;
    public static final byte NEW_LSB_ORDER = 1;
    public static final byte NEW_MSB_ORDER = 2;
    private static final String SIGNATURE = "SQT";
    private static final Logger LOGGER = Logging.getLogger("org.geotools.index.quadtree");
    private byte byteOrder;

    public IndexHeader(ReadableByteChannel readableByteChannel) throws IOException, StoreException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        readableByteChannel.read(byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[3];
        byteBuffer.get(byArray);
        String string = new String(byArray, "US-ASCII");
        if (!string.equals(SIGNATURE)) {
            LOGGER.warning("Old qix file format; this file format is deprecated; It is strongly recommended to regenerate it in new format.");
            byteBuffer.position(0);
            byArray = byteBuffer.array();
            boolean bl = byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 ? byArray[0] != 0 || byArray[1] != 0 : byArray[4] != 0 || byArray[5] != 0;
            this.byteOrder = (byte)(bl ? -1 : -2);
        } else {
            this.byteOrder = byteBuffer.get();
        }
    }

    public byte getByteOrder() {
        return this.byteOrder;
    }
}

