/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;

public class Types {
    public static void validate(Attribute attribute, Object object) throws IllegalAttributeException {
        Types.validate(attribute.getType(), attribute, object, false);
    }

    protected static void validate(AttributeType attributeType, Attribute attribute, Object object, boolean bl) throws IllegalAttributeException {
        if (attributeType == null) {
            throw new IllegalAttributeException("null type");
        }
        if (object == null) {
            if (!attribute.isNillable()) {
                throw new IllegalAttributeException(attributeType.getName() + " not nillable");
            }
            return;
        }
        if (attributeType.isIdentified() && attribute.getIdentifier() == null) {
            throw new NullPointerException(attributeType.getName() + " is identified, null id not accepted");
        }
        if (!bl) {
            Class<?> clazz = object.getClass();
            Class<?> object2 = attributeType.getBinding();
            if (object2 != null && object2 != clazz && !object2.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + attributeType.getName() + " as it is not assignable from " + object2);
            }
        }
        if (attributeType.getRestrictions() != null) {
            for (Filter filter : attributeType.getRestrictions()) {
                if (filter.evaluate(attribute)) continue;
                throw new IllegalAttributeException("Attribute instance (" + attribute.getIdentifier() + ")" + "fails to pass filter: " + filter);
            }
        }
        if (attributeType.getSuper() != null) {
            Types.validate(attributeType.getSuper(), attribute, object, true);
        }
    }

    public static void validate(AttributeDescriptor attributeDescriptor, Object object) throws IllegalAttributeException {
        if (attributeDescriptor == null) {
            throw new NullPointerException("Attribute descriptor required for validation");
        }
        if (object == null) {
            if (!attributeDescriptor.isNillable()) {
                throw new IllegalArgumentException(attributeDescriptor.getName() + " requires a non null value");
            }
        } else {
            Types.validate(attributeDescriptor.getType(), object, false);
        }
    }

    protected static void validate(AttributeType attributeType, Object object, boolean bl) throws IllegalAttributeException {
        if (!bl) {
            Class<?> clazz = object.getClass();
            Class<?> object2 = attributeType.getBinding();
            if (object2 != null && !object2.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + attributeType.getName() + " as it is not assignable from " + object2);
            }
        }
        if (attributeType.getRestrictions() != null && attributeType.getRestrictions().size() > 0) {
            for (Filter filter : attributeType.getRestrictions()) {
                if (filter.evaluate(object)) continue;
                throw new IllegalAttributeException(attributeType.getName() + " restriction " + filter + " not met by: " + object);
            }
        }
        if (attributeType.getSuper() != null) {
            Types.validate(attributeType.getSuper(), object, true);
        }
    }
}

