/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

final class FeatureWriterIterator
implements Iterator<SimpleFeature> {
    FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

    public FeatureWriterIterator(FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter) {
        this.writer = featureWriter;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.writer == null) {
                return false;
            }
            this.writer.write();
            if (this.writer.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (IOException iOException) {
            this.close();
            return false;
        }
    }

    @Override
    public SimpleFeature next() {
        if (this.writer == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        try {
            return this.writer.next();
        }
        catch (IOException iOException) {
            NoSuchElementException noSuchElementException = new NoSuchElementException("Could not obtain the next feature:" + iOException);
            noSuchElementException.initCause(iOException);
            throw noSuchElementException;
        }
    }

    @Override
    public void remove() {
        try {
            this.writer.remove();
        }
        catch (IOException iOException) {
            throw (IllegalStateException)new IllegalStateException("Could not remove feature").initCause(iOException);
        }
    }

    void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
    }
}

