/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.logging.Logging;

public class IndexFile
implements FileReader {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.data.shapefile");
    private static final int RECS_IN_BUFFER = 2000;
    private boolean useMemoryMappedBuffer;
    private FileChannel channel;
    private int channelOffset;
    private ByteBuffer buf = null;
    private int lastIndex = -1;
    private int recOffset;
    private ShapefileHeader header = null;
    private int[] content;
    private StreamLogging streamLogger = new StreamLogging("IndexFile");
    private volatile boolean closed = false;

    public IndexFile(ShpFiles shpFiles, boolean bl) throws IOException {
        this.useMemoryMappedBuffer = bl;
        this.streamLogger.open();
        ReadableByteChannel readableByteChannel = shpFiles.getReadChannel(ShpFileType.SHX, this);
        try {
            if (readableByteChannel instanceof FileChannel) {
                this.channel = (FileChannel)readableByteChannel;
                if (bl) {
                    LOGGER.finest("Memory mapping file...");
                    this.buf = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
                    this.channelOffset = 0;
                } else {
                    LOGGER.finest("Reading from file...");
                    this.buf = NIOUtilities.allocate(16000);
                    this.channel.read(this.buf);
                    this.buf.flip();
                    this.channelOffset = 0;
                }
                this.header = new ShapefileHeader();
                this.header.read(this.buf, true);
            } else {
                LOGGER.finest("Loading all shx...");
                this.readHeader(readableByteChannel);
                this.readRecords(readableByteChannel);
                readableByteChannel.close();
            }
        }
        catch (Throwable throwable) {
            if (readableByteChannel != null) {
                readableByteChannel.close();
            }
            throw (IOException)new IOException(throwable.getLocalizedMessage()).initCause(throwable);
        }
    }

    private void check() {
        if (this.closed) {
            throw new IllegalStateException("Index file has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader(ReadableByteChannel readableByteChannel) throws IOException {
        ByteBuffer byteBuffer = NIOUtilities.allocate(100);
        try {
            while (byteBuffer.remaining() > 0) {
                readableByteChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            this.header = new ShapefileHeader();
            this.header.read(byteBuffer, true);
        }
        finally {
            NIOUtilities.clean(byteBuffer, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecords(ReadableByteChannel readableByteChannel) throws IOException {
        this.check();
        int n = this.header.getFileLength() * 2 - 100;
        ByteBuffer byteBuffer = NIOUtilities.allocate(n);
        try {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            while (byteBuffer.remaining() > 0) {
                readableByteChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            int n2 = n / 4;
            this.content = new int[n2];
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            intBuffer.get(this.content);
        }
        finally {
            NIOUtilities.clean(byteBuffer, false);
        }
    }

    private void readRecord(int n) throws IOException {
        this.check();
        int n2 = 100 + n * 8;
        if (!(this.useMemoryMappedBuffer || n2 - this.channelOffset >= 0 && this.channelOffset + this.buf.limit() > n2 && this.lastIndex != -1)) {
            LOGGER.finest("Filling buffer...");
            this.channelOffset = n2;
            this.channel.position(n2);
            this.buf.clear();
            this.channel.read(this.buf);
            this.buf.flip();
        }
        this.buf.position(n2 - this.channelOffset);
        this.recOffset = this.buf.getInt();
        this.buf.getInt();
        this.lastIndex = n;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
            NIOUtilities.clean(this.buf, this.useMemoryMappedBuffer);
        }
        this.buf = null;
        this.content = null;
        this.channel = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int getRecordCount() {
        return (this.header.getFileLength() * 2 - 100) / 8;
    }

    public int getOffset(int n) throws IOException {
        int n2 = -1;
        if (this.channel != null) {
            if (this.lastIndex != n) {
                this.readRecord(n);
            }
            n2 = this.recOffset;
        } else {
            n2 = this.content[2 * n];
        }
        return n2;
    }

    public int getOffsetInBytes(int n) throws IOException {
        return this.getOffset(n) * 2;
    }
}

