/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureReader
implements DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();

    public ReprojectFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> featureReader, SimpleFeatureType simpleFeatureType, MathTransform mathTransform) {
        this.reader = featureReader;
        this.schema = simpleFeatureType;
        this.transformer.setMathTransform(mathTransform);
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature simpleFeature = this.reader.next();
        Object[] objectArray = simpleFeature.getAttributes().toArray();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Geometry)) continue;
                objectArray[i] = this.transformer.transform((Geometry)objectArray[i]);
            }
        }
        catch (TransformException transformException) {
            throw new DataSourceException("A transformation exception occurred while reprojecting data on the fly", transformException);
        }
        return SimpleFeatureBuilder.build(this.schema, objectArray, simpleFeature.getID());
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

