/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.Query;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.BoundingBox;

public class ListFeatureCollection
extends AbstractFeatureCollection {
    private List<SimpleFeature> list;
    private ReferencedEnvelope bounds = null;

    public ListFeatureCollection(SimpleFeatureType simpleFeatureType, List<SimpleFeature> list) {
        super(simpleFeatureType);
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    protected Iterator openIterator() {
        Iterator<SimpleFeature> iterator = this.list.iterator();
        return iterator;
    }

    protected void closeIterator(Iterator iterator) {
    }

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        BoundingBox boundingBox = simpleFeature.getBounds();
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope(boundingBox.getMinX(), boundingBox.getMaxX(), boundingBox.getMinY(), boundingBox.getMaxY(), this.schema.getCoordinateReferenceSystem());
        } else {
            this.bounds.expandToInclude(boundingBox.getMinX(), boundingBox.getMinY());
            this.bounds.expandToInclude(boundingBox.getMaxX(), boundingBox.getMaxY());
        }
        return this.list.add(simpleFeature);
    }

    @Override
    public void clear() {
        this.bounds = null;
        super.clear();
    }

    @Override
    public SimpleFeatureIterator features() {
        return new ListFeatureIterator(this.list);
    }

    @Override
    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            this.bounds = this.calculateBounds();
        }
        return this.bounds;
    }

    private ReferencedEnvelope calculateBounds() {
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope();
        for (SimpleFeature simpleFeature : this.list) {
            ReferencedEnvelope referencedEnvelope2;
            if (simpleFeature == null || (referencedEnvelope2 = ReferencedEnvelope.reference(simpleFeature.getBounds())) == null || referencedEnvelope2.isEmpty() || referencedEnvelope2.isNull()) continue;
            referencedEnvelope.expandToInclude(referencedEnvelope2);
        }
        return new ReferencedEnvelope(referencedEnvelope, this.schema.getCoordinateReferenceSystem());
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        CollectionFeatureSource collectionFeatureSource = new CollectionFeatureSource(this);
        return collectionFeatureSource.getFeatures(filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy sortBy) {
        Query query = new Query(this.getSchema().getTypeName());
        query.setSortBy(new SortBy[]{sortBy});
        CollectionFeatureSource collectionFeatureSource = new CollectionFeatureSource(this);
        return collectionFeatureSource.getFeatures(query);
    }

    private class ListFeatureIterator
    implements SimpleFeatureIterator {
        private Iterator<SimpleFeature> iter;

        public ListFeatureIterator(List<SimpleFeature> list) {
            this.iter = list.iterator();
        }

        @Override
        public void close() {
            if (this.iter instanceof FeatureIterator) {
                ((FeatureIterator)((Object)this.iter)).close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            return this.iter.next();
        }
    }
}

