/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.PropertyNameResolvingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Utilities;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DataUtilities {
    static Map<String, Class> typeMap = new HashMap<String, Class>();
    static Map<Class, String> typeEncode = new HashMap<Class, String>();
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public static URL fileToURL(File file) {
        try {
            URL uRL = file.toURI().toURL();
            String string = uRL.toExternalForm();
            if (string.contains("+")) {
                string = string.replace("+", "%2B");
            }
            if (string.contains(" ")) {
                string = string.replace(" ", "%20");
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static File urlToFile(URL uRL) {
        String string;
        if (!"file".equals(uRL.getProtocol())) {
            return null;
        }
        String string2 = uRL.toExternalForm();
        if (string2.contains("+")) {
            string2 = string2.replace("+", "%2B");
        }
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Could not decode the URL to UTF-8 format", unsupportedEncodingException);
        }
        String string3 = "file:/";
        String string4 = "file://";
        String string5 = System.getProperty("os.name");
        if (string5.toUpperCase().contains("WINDOWS") && string2.startsWith(string4)) {
            string = string2.substring(string4.length() - 2);
        } else if (string2.startsWith(string4)) {
            string = string2.substring(string4.length());
        } else if (string2.startsWith(string3)) {
            string = string2.substring(string3.length() - 1);
        } else {
            String string6 = uRL.getAuthority();
            String string7 = uRL.getPath().replace("%20", " ");
            string = string6 != null && !string6.equals("") ? "//" + string6 + string7 : string7;
        }
        return new File(string);
    }

    public static Object duplicate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String || object instanceof Integer || object instanceof Double || object instanceof Float || object instanceof Byte || object instanceof Boolean || object instanceof Short || object instanceof Long || object instanceof Character || object instanceof Number) {
            return object;
        }
        if (object instanceof java.util.Date) {
            return new java.util.Date(((java.util.Date)object).getTime());
        }
        if (object instanceof URL || object instanceof URI) {
            return object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = DataUtilities.duplicate(objectArray[i]);
            }
            return objectArray2;
        }
        if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            return geometry.clone();
        }
        if (object instanceof SimpleFeature) {
            SimpleFeature simpleFeature = (SimpleFeature)object;
            return SimpleFeatureBuilder.copy(simpleFeature);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray() && clazz.getComponentType().isPrimitive()) {
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(clazz.getComponentType(), n);
            System.arraycopy(object, 0, object2, 0, n);
            return object2;
        }
        if (clazz.isArray()) {
            int n = Array.getLength(object);
            Object object3 = Array.newInstance(clazz.getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                Array.set(object3, i, DataUtilities.duplicate(Array.get(object, i)));
            }
            return object3;
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(DataUtilities.duplicate(iterator.next()));
            }
            return Collections.unmodifiableList(arrayList);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap hashMap = new HashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                hashMap.put(entry.getKey(), DataUtilities.duplicate(entry.getValue()));
            }
            return Collections.unmodifiableMap(hashMap);
        }
        throw new IllegalAttributeException(null, "Do not know how to deep copy " + clazz.getName());
    }

    public static Object defaultValue(Class clazz) {
        if (clazz == String.class || clazz == Object.class) {
            return "";
        }
        if (clazz == Integer.class) {
            return new Integer(0);
        }
        if (clazz == Double.class) {
            return new Double(0.0);
        }
        if (clazz == Long.class) {
            return new Long(0L);
        }
        if (clazz == Short.class) {
            return new Short(0);
        }
        if (clazz == Float.class) {
            return new Float(0.0f);
        }
        if (clazz == BigDecimal.class) {
            return BigDecimal.valueOf(0L);
        }
        if (clazz == BigInteger.class) {
            return BigInteger.valueOf(0L);
        }
        if (clazz == Character.class) {
            return new Character(' ');
        }
        if (clazz == Boolean.class) {
            return Boolean.FALSE;
        }
        if (clazz == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (clazz == Date.class) {
            return new Date(System.currentTimeMillis());
        }
        if (clazz == Time.class) {
            return new Time(System.currentTimeMillis());
        }
        if (clazz == java.util.Date.class) {
            return new java.util.Date();
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = geometryFactory.createPoint(coordinate);
        if (clazz == Point.class) {
            return point;
        }
        if (clazz == MultiPoint.class) {
            return geometryFactory.createMultiPoint(new Point[]{point});
        }
        if (clazz == LineString.class) {
            return geometryFactory.createLineString(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        }
        LinearRing linearRing = geometryFactory.createLinearRing(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        if (clazz == LinearRing.class) {
            return linearRing;
        }
        if (clazz == MultiLineString.class) {
            return geometryFactory.createMultiLineString(new LineString[]{linearRing});
        }
        Polygon polygon = geometryFactory.createPolygon(linearRing, new LinearRing[0]);
        if (clazz == Polygon.class) {
            return polygon;
        }
        if (clazz == MultiPolygon.class) {
            return geometryFactory.createMultiPolygon(new Polygon[]{polygon});
        }
        throw new IllegalArgumentException(clazz + " is not supported by this method");
    }

    public static List<SimpleFeature> list(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        final ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
        try {
            featureCollection.accepts(new FeatureVisitor(){

                @Override
                public void visit(Feature feature) {
                    arrayList.add((SimpleFeature)feature);
                }
            }, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType simpleFeatureType, String[] stringArray, CoordinateReferenceSystem coordinateReferenceSystem) throws SchemaException {
        URI uRI = null;
        if (simpleFeatureType.getName().getNamespaceURI() != null) {
            try {
                uRI = new URI(simpleFeatureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
        return DataUtilities.createSubType(simpleFeatureType, stringArray, coordinateReferenceSystem, simpleFeatureType.getTypeName(), uRI);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType simpleFeatureType, String[] stringArray, CoordinateReferenceSystem coordinateReferenceSystem, String string, URI uRI) throws SchemaException {
        if (stringArray == null && coordinateReferenceSystem == null) {
            return simpleFeatureType;
        }
        if (stringArray == null) {
            stringArray = new String[simpleFeatureType.getAttributeCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = simpleFeatureType.getDescriptor(i).getLocalName();
            }
        }
        String string2 = uRI != null ? uRI.toString() : null;
        boolean bl = simpleFeatureType.getAttributeCount() == stringArray.length && simpleFeatureType.getTypeName().equals(string) && Utilities.equals(simpleFeatureType.getName().getNamespaceURI(), string2);
        for (int i = 0; i < simpleFeatureType.getAttributeCount() && bl; ++i) {
            AttributeDescriptor attributeDescriptor = simpleFeatureType.getDescriptor(i);
            bl = attributeDescriptor.getLocalName().equals(stringArray[i]) && (coordinateReferenceSystem == null || !(attributeDescriptor instanceof GeometryDescriptor) || DataUtilities.assertEquals(coordinateReferenceSystem, ((GeometryDescriptor)attributeDescriptor).getCoordinateReferenceSystem()));
        }
        if (bl) {
            return simpleFeatureType;
        }
        AttributeDescriptor[] attributeDescriptorArray = new AttributeDescriptor[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            attributeDescriptorArray[i] = simpleFeatureType.getDescriptor(stringArray[i]);
            if (coordinateReferenceSystem == null || !(attributeDescriptorArray[i] instanceof GeometryDescriptor)) continue;
            AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
            attributeTypeBuilder.init(attributeDescriptorArray[i]);
            attributeTypeBuilder.setCRS(coordinateReferenceSystem);
            attributeDescriptorArray[i] = attributeTypeBuilder.buildDescriptor(attributeDescriptorArray[i].getLocalName(), attributeTypeBuilder.buildGeometryType());
        }
        if (string == null) {
            string = simpleFeatureType.getTypeName();
        }
        if (uRI == null && simpleFeatureType.getName().getNamespaceURI() != null) {
            try {
                uRI = new URI(simpleFeatureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(string);
        simpleFeatureTypeBuilder.setNamespaceURI(uRI);
        simpleFeatureTypeBuilder.addAll(attributeDescriptorArray);
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    private static boolean assertEquals(Object object, Object object2) {
        return object == null && object2 == null ? true : (object != null ? object.equals(object2) : false);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType simpleFeatureType, String[] stringArray) throws SchemaException {
        if (stringArray == null) {
            return simpleFeatureType;
        }
        boolean bl = simpleFeatureType.getAttributeCount() == stringArray.length;
        for (int i = 0; i < simpleFeatureType.getAttributeCount() && bl; ++i) {
            bl = simpleFeatureType.getDescriptor(i).getLocalName().equals(stringArray[i]);
        }
        if (bl) {
            return simpleFeatureType;
        }
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(simpleFeatureType.getName());
        for (int i = 0; i < stringArray.length; ++i) {
            simpleFeatureTypeBuilder.add(simpleFeatureType.getDescriptor(stringArray[i]));
        }
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    public static Comparator<SimpleFeature> sortComparator(SortBy sortBy) {
        if (sortBy == null) {
            sortBy = SortBy.NATURAL_ORDER;
        }
        if (sortBy == SortBy.NATURAL_ORDER) {
            return new Comparator<SimpleFeature>(){

                @Override
                public int compare(SimpleFeature simpleFeature, SimpleFeature simpleFeature2) {
                    return simpleFeature.getID().compareTo(simpleFeature2.getID());
                }
            };
        }
        if (sortBy == SortBy.REVERSE_ORDER) {
            return new Comparator<SimpleFeature>(){

                @Override
                public int compare(SimpleFeature simpleFeature, SimpleFeature simpleFeature2) {
                    int n = simpleFeature.getID().compareTo(simpleFeature2.getID());
                    return -n;
                }
            };
        }
        final PropertyName propertyName = sortBy.getPropertyName();
        return new Comparator<SimpleFeature>(){

            @Override
            public int compare(SimpleFeature simpleFeature, SimpleFeature simpleFeature2) {
                Comparable comparable = propertyName.evaluate(simpleFeature, Comparable.class);
                Comparable comparable2 = propertyName.evaluate(simpleFeature2, Comparable.class);
                if (comparable == null || comparable2 == null) {
                    return 0;
                }
                if (comparable instanceof Comparable && comparable.getClass().isInstance(comparable2)) {
                    return comparable.compareTo(comparable2);
                }
                return 0;
            }
        };
    }

    public static Query mixQueries(Query query, Query query2, String string) {
        String string2;
        if (query == null && query2 == null) {
            return Query.ALL;
        }
        if (query == null || query.equals(Query.ALL)) {
            return query2;
        }
        if (query2 == null || query2.equals(Query.ALL)) {
            return query;
        }
        if (query.getTypeName() != null && query2.getTypeName() != null && !query.getTypeName().equals(query2.getTypeName())) {
            String string3 = "Type names do not match: " + query.getTypeName() + " != " + query2.getTypeName();
            throw new IllegalArgumentException(string3);
        }
        if (query.getVersion() != null) {
            if (query2.getVersion() != null && !query2.getVersion().equals(query.getVersion())) {
                throw new IllegalArgumentException("First and second query refer different versions");
            }
            string2 = query.getVersion();
        } else {
            string2 = query2.getVersion();
        }
        int n = Math.min(query.getMaxFeatures(), query2.getMaxFeatures());
        String[] stringArray = DataUtilities.joinAttributes(query.getPropertyNames(), query2.getPropertyNames());
        Filter filter = query.getFilter();
        Filter filter2 = query2.getFilter();
        if (filter == null || filter.equals(Filter.INCLUDE)) {
            filter = filter2;
        } else if (filter2 != null && !filter2.equals(Filter.INCLUDE)) {
            filter = ff.and(filter, filter2);
        }
        Integer n2 = 0;
        if (query.getStartIndex() != null) {
            n2 = query.getStartIndex();
        }
        if (query2.getStartIndex() != null) {
            n2 = n2 + query2.getStartIndex();
        }
        Hints hints = new Hints();
        if (query.getHints() != null) {
            hints.putAll((Map<?, ?>)query.getHints());
        }
        if (query2.getHints() != null) {
            hints.putAll((Map<?, ?>)query2.getHints());
        }
        String string4 = query.getTypeName() != null ? query.getTypeName() : query2.getTypeName();
        Query query3 = new Query(string4, filter, n, stringArray, string);
        query3.setVersion(string2);
        query3.setHints(hints);
        if (n2 != 0) {
            query3.setStartIndex(n2);
        }
        return query3;
    }

    public static Query resolvePropertyNames(Query query, SimpleFeatureType simpleFeatureType) {
        Filter filter = DataUtilities.resolvePropertyNames(query.getFilter(), simpleFeatureType);
        if (filter == query.getFilter()) {
            return query;
        }
        Query query2 = new Query(query);
        query2.setFilter(filter);
        return query2;
    }

    public static Filter resolvePropertyNames(Filter filter, SimpleFeatureType simpleFeatureType) {
        if (filter == null || filter == Filter.INCLUDE || filter == Filter.EXCLUDE) {
            return filter;
        }
        return (Filter)filter.accept(new PropertyNameResolvingVisitor(simpleFeatureType), null);
    }

    private static String[] joinAttributes(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = null;
        if (stringArray == null && stringArray2 == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (stringArray != null) {
            linkedList.addAll(Arrays.asList(stringArray));
        }
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (linkedList.contains(stringArray2[i])) continue;
                linkedList.add(stringArray2[i]);
            }
        }
        stringArray3 = new String[linkedList.size()];
        linkedList.toArray(stringArray3);
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Envelope bounds(FeatureCollection<? extends FeatureType, ? extends Feature> featureCollection) {
        FeatureIterator<? extends Feature> featureIterator = featureCollection.features();
        try {
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(featureCollection.getSchema().getCoordinateReferenceSystem());
            if (!featureIterator.hasNext()) {
                referencedEnvelope.setToNull();
                ReferencedEnvelope referencedEnvelope2 = referencedEnvelope;
                return referencedEnvelope2;
            }
            referencedEnvelope.init(((SimpleFeature)featureIterator.next()).getBounds());
            ReferencedEnvelope referencedEnvelope3 = referencedEnvelope;
            return referencedEnvelope3;
        }
        finally {
            featureIterator.close();
        }
    }

    static {
        typeEncode.put(String.class, "String");
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
        typeMap.put("\"\"", String.class);
        typeEncode.put(Integer.class, "Integer");
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.class);
        typeMap.put("0", Integer.class);
        typeEncode.put(Double.class, "Double");
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.class);
        typeMap.put("0.0", Double.class);
        typeEncode.put(Float.class, "Float");
        typeMap.put("Float", Float.class);
        typeMap.put("float", Float.class);
        typeMap.put("0.0f", Float.class);
        typeEncode.put(Boolean.class, "Boolean");
        typeMap.put("Boolean", Boolean.class);
        typeMap.put("true", Boolean.class);
        typeMap.put("false", Boolean.class);
        typeEncode.put(Geometry.class, "Geometry");
        typeMap.put("Geometry", Geometry.class);
        typeEncode.put(Point.class, "Point");
        typeMap.put("Point", Point.class);
        typeEncode.put(LineString.class, "LineString");
        typeMap.put("LineString", LineString.class);
        typeEncode.put(Polygon.class, "Polygon");
        typeMap.put("Polygon", Polygon.class);
        typeEncode.put(MultiPoint.class, "MultiPoint");
        typeMap.put("MultiPoint", MultiPoint.class);
        typeEncode.put(MultiLineString.class, "MultiLineString");
        typeMap.put("MultiLineString", MultiLineString.class);
        typeEncode.put(MultiPolygon.class, "MultiPolygon");
        typeMap.put("MultiPolygon", MultiPolygon.class);
        typeEncode.put(GeometryCollection.class, "GeometryCollection");
        typeMap.put("GeometryCollection", GeometryCollection.class);
        typeEncode.put(java.util.Date.class, "Date");
        typeMap.put("Date", java.util.Date.class);
    }
}

