/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;

public class DirectoryNode
extends EntryNode
implements DirectoryEntry {
    private Map<String, Entry> _byname;
    private ArrayList<Entry> _entries;
    private POIFSFileSystem _filesystem;
    private POIFSDocumentPath _path;

    DirectoryNode(DirectoryProperty directoryProperty, POIFSFileSystem pOIFSFileSystem, DirectoryNode directoryNode) {
        super(directoryProperty, directoryNode);
        this._path = directoryNode == null ? new POIFSDocumentPath() : new POIFSDocumentPath(directoryNode._path, new String[]{directoryProperty.getName()});
        this._filesystem = pOIFSFileSystem;
        this._byname = new HashMap<String, Entry>();
        this._entries = new ArrayList();
        Iterator<Property> iterator = directoryProperty.getChildren();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            EntryNode entryNode = null;
            entryNode = property.isDirectory() ? new DirectoryNode((DirectoryProperty)property, this._filesystem, this) : new DocumentNode((DocumentProperty)property, this);
            this._entries.add(entryNode);
            this._byname.put(entryNode.getName(), entryNode);
        }
    }

    public DocumentInputStream createDocumentInputStream(String string) throws IOException {
        Entry entry = this.getEntry(string);
        if (!entry.isDocumentEntry()) {
            throw new IOException("Entry '" + string + "' is not a DocumentEntry");
        }
        return new DocumentInputStream((DocumentEntry)entry);
    }

    DocumentEntry createDocument(POIFSDocument pOIFSDocument) throws IOException {
        DocumentProperty documentProperty = pOIFSDocument.getDocumentProperty();
        DocumentNode documentNode = new DocumentNode(documentProperty, this);
        ((DirectoryProperty)this.getProperty()).addChild(documentProperty);
        this._filesystem.addDocument(pOIFSDocument);
        this._entries.add(documentNode);
        this._byname.put(documentProperty.getName(), documentNode);
        return documentNode;
    }

    boolean deleteEntry(EntryNode entryNode) {
        boolean bl = ((DirectoryProperty)this.getProperty()).deleteChild(entryNode.getProperty());
        if (bl) {
            this._entries.remove(entryNode);
            this._byname.remove(entryNode.getName());
            this._filesystem.remove(entryNode);
        }
        return bl;
    }

    @Override
    public Iterator<Entry> getEntries() {
        return this._entries.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    @Override
    public Entry getEntry(String string) throws FileNotFoundException {
        Entry entry = null;
        if (string != null) {
            entry = this._byname.get(string);
        }
        if (entry == null) {
            throw new FileNotFoundException("no such entry: \"" + string + "\"");
        }
        return entry;
    }

    @Override
    public DocumentEntry createDocument(String string, InputStream inputStream) throws IOException {
        return this.createDocument(new POIFSDocument(string, inputStream));
    }

    @Override
    public DirectoryEntry createDirectory(String string) throws IOException {
        DirectoryProperty directoryProperty = new DirectoryProperty(string);
        DirectoryNode directoryNode = new DirectoryNode(directoryProperty, this._filesystem, this);
        ((DirectoryProperty)this.getProperty()).addChild(directoryProperty);
        this._filesystem.addDirectory(directoryProperty);
        this._entries.add(directoryNode);
        this._byname.put(string, directoryNode);
        return directoryNode;
    }

    @Override
    public void setStorageClsid(ClassID classID) {
        this.getProperty().setStorageClsid(classID);
    }

    @Override
    public boolean isDirectoryEntry() {
        return true;
    }

    @Override
    protected boolean isDeleteOK() {
        return this.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.getEntries();
    }
}

