/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.OldReferencingObjectCache;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class ThreadedAuthorityFactory
extends AbstractAuthorityFactory
implements BufferedFactory {
    static final int DEFAULT_MAX = 20;
    AbstractAuthorityFactory backingStore;
    private final OldReferencingObjectCache objectCache;
    private final Map<IdentifiedObject, IdentifiedObject> findPool = new WeakHashMap<IdentifiedObject, IdentifiedObject>();

    protected ThreadedAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory) {
        this(abstractAuthorityFactory, 20);
    }

    protected ThreadedAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory, int n) {
        super(abstractAuthorityFactory.getPriority());
        while (abstractAuthorityFactory instanceof ThreadedAuthorityFactory) {
            abstractAuthorityFactory = ((ThreadedAuthorityFactory)abstractAuthorityFactory).backingStore;
        }
        this.backingStore = abstractAuthorityFactory;
        this.objectCache = new OldReferencingObjectCache(n);
        this.completeHints();
    }

    final void completeHints() {
        if (this.backingStore instanceof DatumAuthorityFactory) {
            this.hints.put(Hints.DATUM_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CSAuthorityFactory) {
            this.hints.put(Hints.CS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CRSAuthorityFactory) {
            this.hints.put(Hints.CRS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CoordinateOperationAuthorityFactory) {
            this.hints.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.backingStore);
        }
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Object object;
        try {
            object = this.getBackingStore();
        }
        catch (FactoryException factoryException) {
            object = factoryException;
        }
        return Collections.singleton(object);
    }

    AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (this.backingStore == null) {
            throw new FactoryException(Errors.format(42));
        }
        return this.backingStore;
    }

    @Override
    boolean isAvailable() {
        try {
            return this.getBackingStore().isAvailable();
        }
        catch (FactoryNotFoundException factoryNotFoundException) {
        }
        catch (FactoryException factoryException) {
            Citation citation = this.getAuthority();
            Collection<? extends InternationalString> collection = citation.getAlternateTitles();
            InternationalString internationalString = citation.getTitle();
            if (collection != null) {
                for (InternationalString internationalString2 : collection) {
                    if (internationalString2.length() <= internationalString.length()) continue;
                    internationalString = internationalString2;
                }
            }
            LogRecord logRecord = Loggings.format(Level.WARNING, 42, internationalString);
            logRecord.setSourceClassName(this.getClass().getName());
            logRecord.setSourceMethodName("isAvailable");
            logRecord.setThrown(factoryException);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
        return false;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        AbstractAuthorityFactory abstractAuthorityFactory = this.backingStore;
        if (abstractAuthorityFactory != null && abstractAuthorityFactory.sameAuthorityCodes(authorityFactory)) {
            return true;
        }
        return super.sameAuthorityCodes(authorityFactory);
    }

    @Override
    public Citation getVendor() {
        return this.backingStore != null ? this.backingStore.getVendor() : super.getVendor();
    }

    @Override
    public Citation getAuthority() {
        return this.backingStore != null ? this.backingStore.getAuthority() : null;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        return this.getBackingStore().getBackingStoreDescription();
    }

    public Set<String> getAuthorityCodes(Class clazz) throws FactoryException {
        return this.getBackingStore().getAuthorityCodes(clazz);
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return this.getBackingStore().getDescriptionText(string);
    }

    @Override
    public synchronized IdentifiedObject createObject(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        IdentifiedObject identifiedObject = object instanceof IdentifiedObject ? (IdentifiedObject)object : this.getBackingStore().createObject(string);
        this.objectCache.put(string2, identifiedObject);
        return identifiedObject;
    }

    @Override
    public synchronized Datum createDatum(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        Datum datum = object instanceof Datum ? (Datum)object : this.getBackingStore().createDatum(string);
        this.objectCache.put(string2, datum);
        return datum;
    }

    @Override
    public synchronized EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        EngineeringDatum engineeringDatum = object instanceof EngineeringDatum ? (EngineeringDatum)object : this.getBackingStore().createEngineeringDatum(string);
        this.objectCache.put(string2, engineeringDatum);
        return engineeringDatum;
    }

    @Override
    public synchronized ImageDatum createImageDatum(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        ImageDatum imageDatum = object instanceof ImageDatum ? (ImageDatum)object : this.getBackingStore().createImageDatum(string);
        this.objectCache.put(string2, imageDatum);
        return imageDatum;
    }

    @Override
    public synchronized VerticalDatum createVerticalDatum(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        VerticalDatum verticalDatum = object instanceof VerticalDatum ? (VerticalDatum)object : this.getBackingStore().createVerticalDatum(string);
        this.objectCache.put(string2, verticalDatum);
        return verticalDatum;
    }

    @Override
    public synchronized TemporalDatum createTemporalDatum(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        TemporalDatum temporalDatum = object instanceof TemporalDatum ? (TemporalDatum)object : this.getBackingStore().createTemporalDatum(string);
        this.objectCache.put(string2, temporalDatum);
        return temporalDatum;
    }

    @Override
    public synchronized GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        GeodeticDatum geodeticDatum = object instanceof GeodeticDatum ? (GeodeticDatum)object : this.getBackingStore().createGeodeticDatum(string);
        this.objectCache.put(string2, geodeticDatum);
        return geodeticDatum;
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        Ellipsoid ellipsoid = object instanceof Ellipsoid ? (Ellipsoid)object : this.getBackingStore().createEllipsoid(string);
        this.objectCache.put(string2, ellipsoid);
        return ellipsoid;
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        PrimeMeridian primeMeridian = object instanceof PrimeMeridian ? (PrimeMeridian)object : this.getBackingStore().createPrimeMeridian(string);
        this.objectCache.put(string2, primeMeridian);
        return primeMeridian;
    }

    @Override
    public synchronized Extent createExtent(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        Extent extent = object instanceof Extent ? (Extent)object : this.getBackingStore().createExtent(string);
        this.objectCache.put(string2, extent);
        return extent;
    }

    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        CoordinateSystem coordinateSystem = object instanceof CoordinateSystem ? (CoordinateSystem)object : this.getBackingStore().createCoordinateSystem(string);
        this.objectCache.put(string2, coordinateSystem);
        return coordinateSystem;
    }

    @Override
    public synchronized CartesianCS createCartesianCS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        CartesianCS cartesianCS = object instanceof CartesianCS ? (CartesianCS)object : this.getBackingStore().createCartesianCS(string);
        this.objectCache.put(string2, cartesianCS);
        return cartesianCS;
    }

    @Override
    public synchronized PolarCS createPolarCS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        PolarCS polarCS = object instanceof PolarCS ? (PolarCS)object : this.getBackingStore().createPolarCS(string);
        this.objectCache.put(string2, polarCS);
        return polarCS;
    }

    @Override
    public synchronized CylindricalCS createCylindricalCS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        CylindricalCS cylindricalCS = object instanceof CylindricalCS ? (CylindricalCS)object : this.getBackingStore().createCylindricalCS(string);
        this.objectCache.put(string2, cylindricalCS);
        return cylindricalCS;
    }

    @Override
    public synchronized SphericalCS createSphericalCS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        SphericalCS sphericalCS = object instanceof SphericalCS ? (SphericalCS)object : this.getBackingStore().createSphericalCS(string);
        this.objectCache.put(string2, sphericalCS);
        return sphericalCS;
    }

    @Override
    public synchronized EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        EllipsoidalCS ellipsoidalCS = object instanceof EllipsoidalCS ? (EllipsoidalCS)object : this.getBackingStore().createEllipsoidalCS(string);
        this.objectCache.put(string2, ellipsoidalCS);
        return ellipsoidalCS;
    }

    @Override
    public synchronized VerticalCS createVerticalCS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        VerticalCS verticalCS = object instanceof VerticalCS ? (VerticalCS)object : this.getBackingStore().createVerticalCS(string);
        this.objectCache.put(string2, verticalCS);
        return verticalCS;
    }

    @Override
    public synchronized TimeCS createTimeCS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        TimeCS timeCS = object instanceof TimeCS ? (TimeCS)object : this.getBackingStore().createTimeCS(string);
        this.objectCache.put(string2, timeCS);
        return timeCS;
    }

    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        CoordinateSystemAxis coordinateSystemAxis = object instanceof CoordinateSystemAxis ? (CoordinateSystemAxis)object : this.getBackingStore().createCoordinateSystemAxis(string);
        this.objectCache.put(string2, coordinateSystemAxis);
        return coordinateSystemAxis;
    }

    @Override
    public synchronized Unit<?> createUnit(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        Unit<?> unit = object instanceof Unit ? (Unit<?>)object : this.getBackingStore().createUnit(string);
        this.objectCache.put(string2, unit);
        return unit;
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        CoordinateReferenceSystem coordinateReferenceSystem = object instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)object : this.getBackingStore().createCoordinateReferenceSystem(string);
        this.objectCache.put(string2, coordinateReferenceSystem);
        return coordinateReferenceSystem;
    }

    @Override
    public synchronized CompoundCRS createCompoundCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        CompoundCRS compoundCRS = object instanceof CompoundCRS ? (CompoundCRS)object : this.getBackingStore().createCompoundCRS(string);
        this.objectCache.put(string2, compoundCRS);
        return compoundCRS;
    }

    @Override
    public synchronized DerivedCRS createDerivedCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        DerivedCRS derivedCRS = object instanceof DerivedCRS ? (DerivedCRS)object : this.getBackingStore().createDerivedCRS(string);
        this.objectCache.put(string2, derivedCRS);
        return derivedCRS;
    }

    @Override
    public synchronized EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        EngineeringCRS engineeringCRS = object instanceof EngineeringCRS ? (EngineeringCRS)object : this.getBackingStore().createEngineeringCRS(string);
        this.objectCache.put(string2, engineeringCRS);
        return engineeringCRS;
    }

    @Override
    public synchronized GeographicCRS createGeographicCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        GeographicCRS geographicCRS = object instanceof GeographicCRS ? (GeographicCRS)object : this.getBackingStore().createGeographicCRS(string);
        this.objectCache.put(string2, geographicCRS);
        return geographicCRS;
    }

    @Override
    public synchronized GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        GeocentricCRS geocentricCRS = object instanceof GeocentricCRS ? (GeocentricCRS)object : this.getBackingStore().createGeocentricCRS(string);
        this.objectCache.put(string2, geocentricCRS);
        return geocentricCRS;
    }

    @Override
    public synchronized ImageCRS createImageCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        ImageCRS imageCRS = object instanceof ImageCRS ? (ImageCRS)object : this.getBackingStore().createImageCRS(string);
        this.objectCache.put(string2, imageCRS);
        return imageCRS;
    }

    @Override
    public synchronized ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        ProjectedCRS projectedCRS = object instanceof ProjectedCRS ? (ProjectedCRS)object : this.getBackingStore().createProjectedCRS(string);
        this.objectCache.put(string2, projectedCRS);
        return projectedCRS;
    }

    @Override
    public synchronized TemporalCRS createTemporalCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        TemporalCRS temporalCRS = object instanceof TemporalCRS ? (TemporalCRS)object : this.getBackingStore().createTemporalCRS(string);
        this.objectCache.put(string2, temporalCRS);
        return temporalCRS;
    }

    @Override
    public synchronized VerticalCRS createVerticalCRS(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        VerticalCRS verticalCRS = object instanceof VerticalCRS ? (VerticalCRS)object : this.getBackingStore().createVerticalCRS(string);
        this.objectCache.put(string2, verticalCRS);
        return verticalCRS;
    }

    @Override
    public synchronized ParameterDescriptor createParameterDescriptor(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        ParameterDescriptor parameterDescriptor = object instanceof ParameterDescriptor ? (ParameterDescriptor)object : this.getBackingStore().createParameterDescriptor(string);
        this.objectCache.put(string2, parameterDescriptor);
        return parameterDescriptor;
    }

    @Override
    public synchronized OperationMethod createOperationMethod(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        OperationMethod operationMethod = object instanceof OperationMethod ? (OperationMethod)object : this.getBackingStore().createOperationMethod(string);
        this.objectCache.put(string2, operationMethod);
        return operationMethod;
    }

    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        String string2 = this.trimAuthority(string);
        Object object = this.objectCache.get(string2);
        CoordinateOperation coordinateOperation = object instanceof CoordinateOperation ? (CoordinateOperation)object : this.getBackingStore().createCoordinateOperation(string);
        this.objectCache.put(string2, coordinateOperation);
        return coordinateOperation;
    }

    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        CodePair codePair = new CodePair(this.trimAuthority(string), this.trimAuthority(string2));
        Object object = this.objectCache.get(codePair);
        Set<CoordinateOperation> set = object instanceof CoordinateOperation ? (Set<CoordinateOperation>)object : Collections.unmodifiableSet(this.getBackingStore().createFromCoordinateReferenceSystemCodes(string, string2));
        this.objectCache.put(codePair, set);
        return set;
    }

    @Override
    public synchronized IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(this.getBackingStore().getIdentifiedObjectFinder(clazz));
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        if (this.backingStore != null) {
            this.backingStore.dispose();
            this.backingStore = null;
        }
        this.objectCache.clear();
        super.dispose();
    }

    private final class Finder
    extends IdentifiedObjectFinder.Adapter {
        Finder(IdentifiedObjectFinder identifiedObjectFinder) {
            super(identifiedObjectFinder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2;
            Map map = ThreadedAuthorityFactory.this.findPool;
            synchronized (map) {
                identifiedObject2 = (IdentifiedObject)ThreadedAuthorityFactory.this.findPool.get(identifiedObject);
            }
            if (identifiedObject2 == null && (identifiedObject2 = this.finder.find(identifiedObject)) != null) {
                map = ThreadedAuthorityFactory.this.findPool;
                synchronized (map) {
                    ThreadedAuthorityFactory.this.findPool.put(identifiedObject, identifiedObject2);
                }
            }
            return identifiedObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
            IdentifiedObject identifiedObject2;
            Map map = ThreadedAuthorityFactory.this.findPool;
            synchronized (map) {
                identifiedObject2 = (IdentifiedObject)ThreadedAuthorityFactory.this.findPool.get(identifiedObject);
            }
            if (identifiedObject2 != null) {
                return this.getIdentifier(identifiedObject2);
            }
            return this.finder.findIdentifier(identifiedObject);
        }
    }

    private static final class CodePair {
        private final String source;
        private final String target;

        public CodePair(String string, String string2) {
            this.source = string;
            this.target = string2;
        }

        public int hashCode() {
            int n = 0;
            if (this.source != null) {
                n = this.source.hashCode();
            }
            if (this.target != null) {
                n += this.target.hashCode() * 37;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof CodePair) {
                CodePair codePair = (CodePair)object;
                return Utilities.equals(this.source, codePair.source) && Utilities.equals(this.target, codePair.target);
            }
            return false;
        }

        public String toString() {
            return this.source + " \u21e8 " + this.target;
        }
    }
}

