/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;

public final class CRS {
    static final Logger LOGGER = Logging.getLogger(CRS.class);
    private static final Hints FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
    private static CRSAuthorityFactory defaultFactory;
    private static CRSAuthorityFactory xyFactory;
    private static CoordinateOperationFactory strictFactory;
    private static CoordinateOperationFactory lenientFactory;

    private CRS() {
    }

    public static synchronized CRSAuthorityFactory getAuthorityFactory(boolean bl) throws FactoryRegistryException {
        CRSAuthorityFactory cRSAuthorityFactory;
        CRSAuthorityFactory cRSAuthorityFactory2 = cRSAuthorityFactory = bl ? xyFactory : defaultFactory;
        if (cRSAuthorityFactory == null) {
            try {
                cRSAuthorityFactory = new DefaultAuthorityFactory(bl);
                if (bl) {
                    xyFactory = cRSAuthorityFactory;
                } else {
                    defaultFactory = cRSAuthorityFactory;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new FactoryNotFoundException(null, noSuchElementException);
            }
        }
        return cRSAuthorityFactory;
    }

    public static synchronized CoordinateOperationFactory getCoordinateOperationFactory(boolean bl) {
        CoordinateOperationFactory coordinateOperationFactory;
        CoordinateOperationFactory coordinateOperationFactory2 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
        if (coordinateOperationFactory == null) {
            Hints hints = GeoTools.getDefaultHints();
            if (bl) {
                hints.put(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            }
            coordinateOperationFactory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
            if (bl) {
                lenientFactory = coordinateOperationFactory;
            } else {
                strictFactory = coordinateOperationFactory;
            }
        }
        return coordinateOperationFactory;
    }

    public static CoordinateReferenceSystem decode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode(string, false);
    }

    public static CoordinateReferenceSystem decode(String string, boolean bl) throws NoSuchAuthorityCodeException, FactoryException {
        string = string.trim().toUpperCase();
        return CRS.getAuthorityFactory(bl).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem parseWKT(String string) throws FactoryException {
        return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(string);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        Extent extent;
        GeographicBoundingBox geographicBoundingBox = null;
        GeographicBoundingBoxImpl geographicBoundingBoxImpl = null;
        if (coordinateReferenceSystem != null && (extent = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox geographicBoundingBox2 = (GeographicBoundingBox)geographicExtent;
                if (geographicBoundingBox == null) {
                    geographicBoundingBox = geographicBoundingBox2;
                    continue;
                }
                if (geographicBoundingBoxImpl == null) {
                    geographicBoundingBoxImpl = new GeographicBoundingBoxImpl(geographicBoundingBox);
                    geographicBoundingBox = geographicBoundingBoxImpl;
                }
                geographicBoundingBoxImpl.add(geographicBoundingBox2);
            }
        }
        return geographicBoundingBox;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        Datum datum = CRSUtilities.getDatum(coordinateReferenceSystem);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getCoordinateReferenceSystems()) {
                Ellipsoid ellipsoid = CRS.getEllipsoid(coordinateReferenceSystem2);
                if (ellipsoid == null) continue;
                return ellipsoid;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).equals((AbstractIdentifiedObject)object2, false);
        }
        return object != null && object.equals(object2);
    }

    public static String toSRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        Set<ReferenceIdentifier> set;
        boolean bl = false;
        try {
            bl = Boolean.getBoolean("org.geotools.referencing.forceXY") || Boolean.TRUE.equals(Hints.getSystemDefault(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Failed to determine if we are in forced lon/lat mode", exception);
        }
        if (bl && CRS.getAxisOrder(coordinateReferenceSystem, false) == AxisOrder.NORTH_EAST) {
            try {
                set = CRS.lookupEpsgCode(coordinateReferenceSystem, false);
                if (set != null) {
                    return "urn:ogc:def:crs:EPSG::" + set;
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, "Failed to determine EPSG code", exception);
            }
        }
        if (coordinateReferenceSystem == null) {
            return null;
        }
        set = coordinateReferenceSystem.getIdentifiers();
        if (set.isEmpty()) {
            ReferenceIdentifier referenceIdentifier = coordinateReferenceSystem.getName();
            if (referenceIdentifier != null) {
                return referenceIdentifier.toString();
            }
        } else {
            return set.iterator().next().toString();
        }
        return null;
    }

    public static String lookupIdentifier(Citation citation, CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws FactoryException {
        ReferenceIdentifier referenceIdentifier = AbstractIdentifiedObject.getIdentifier(coordinateReferenceSystem, citation);
        if (referenceIdentifier != null) {
            return referenceIdentifier.getCode();
        }
        for (CRSAuthorityFactory cRSAuthorityFactory : ReferencingFactoryFinder.getCRSAuthorityFactories(FORCE_LONGITUDE_FIRST_AXIS_ORDER)) {
            if (!Citations.identifierMatches(cRSAuthorityFactory.getAuthority(), citation) || !(cRSAuthorityFactory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory abstractAuthorityFactory = (AbstractAuthorityFactory)((Object)cRSAuthorityFactory);
            IdentifiedObjectFinder identifiedObjectFinder = abstractAuthorityFactory.getIdentifiedObjectFinder(coordinateReferenceSystem.getClass());
            identifiedObjectFinder.setFullScanAllowed(bl);
            String string = identifiedObjectFinder.findIdentifier(coordinateReferenceSystem);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static Integer lookupEpsgCode(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws FactoryException {
        String string = CRS.lookupIdentifier(Citations.EPSG, coordinateReferenceSystem, bl);
        if (string != null) {
            int n = string.lastIndexOf(58);
            String string2 = string.substring(n + 1);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FactoryException(Errors.format(67, string), numberFormatException);
            }
        }
        return null;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        return CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2, false);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            return IdentityTransform.create(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        }
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(bl);
        return coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
    }

    public static AxisOrder getAxisOrder(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) {
        CoordinateSystem coordinateSystem = null;
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            coordinateSystem = !bl ? coordinateReferenceSystem.getCoordinateSystem() : ((ProjectedCRS)coordinateReferenceSystem).getBaseCRS().getCoordinateSystem();
        } else if (coordinateReferenceSystem instanceof GeographicCRS) {
            coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        } else {
            return AxisOrder.INAPPLICABLE;
        }
        int n = coordinateSystem.getDimension();
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            AxisDirection axisDirection = coordinateSystem.getAxis(i).getDirection().absolute();
            if (axisDirection.equals(AxisDirection.EAST)) {
                n2 = i;
            }
            if (!axisDirection.equals(AxisDirection.NORTH)) continue;
            n3 = i;
        }
        if (n2 >= 0 && n3 >= 0) {
            if (n2 < n3) {
                return AxisOrder.EAST_NORTH;
            }
            return AxisOrder.NORTH_EAST;
        }
        return AxisOrder.INAPPLICABLE;
    }

    static {
        GeoTools.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    defaultFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static enum AxisOrder {
        EAST_NORTH,
        NORTH_EAST,
        INAPPLICABLE;

    }
}

