/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.IOException;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureLock;
import org.geotools.data.LockingManager;
import org.geotools.data.Transaction;
import org.geotools.data.directory.DirectoryTypeCache;

public class DirectoryLockingManager
implements LockingManager {
    DirectoryTypeCache cache;

    public DirectoryLockingManager(DirectoryTypeCache directoryTypeCache) {
        this.cache = directoryTypeCache;
    }

    @Override
    public boolean exists(String string) {
        List<DataStore> list = this.cache.getDataStores();
        for (DataStore dataStore : list) {
            if (dataStore.getLockingManager() == null || !dataStore.getLockingManager().exists(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean release(String string, Transaction transaction) throws IOException {
        List<DataStore> list = this.cache.getDataStores();
        for (DataStore dataStore : list) {
            if (dataStore.getLockingManager() == null || !dataStore.getLockingManager().exists(string)) continue;
            return dataStore.getLockingManager().release(string, transaction);
        }
        return false;
    }

    @Override
    public boolean refresh(String string, Transaction transaction) throws IOException {
        List<DataStore> list = this.cache.getDataStores();
        for (DataStore dataStore : list) {
            if (dataStore.getLockingManager() == null || !dataStore.getLockingManager().exists(string)) continue;
            return dataStore.getLockingManager().refresh(string, transaction);
        }
        return false;
    }

    @Override
    public void unLockFeatureID(String string, String string2, Transaction transaction, FeatureLock featureLock) throws IOException {
        DataStore dataStore = this.cache.getDataStore(string, false);
        if (dataStore != null && dataStore.getLockingManager() != null) {
            dataStore.getLockingManager().unLockFeatureID(string, string2, transaction, featureLock);
        }
    }

    @Override
    public void lockFeatureID(String string, String string2, Transaction transaction, FeatureLock featureLock) throws IOException {
        DataStore dataStore = this.cache.getDataStore(string, false);
        if (dataStore != null && dataStore.getLockingManager() != null) {
            dataStore.getLockingManager().lockFeatureID(string, string2, transaction, featureLock);
        }
    }
}

