/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import javax.measure.Measure;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

public abstract class VectorMeasure<Q extends Quantity>
extends Measure<double[], Q> {
    protected VectorMeasure() {
    }

    public static <Q extends Quantity> VectorMeasure<Q> valueOf(double d, double d2, Unit<Q> unit) {
        return new TwoDimensional(d, d2, unit);
    }

    public static <Q extends Quantity> VectorMeasure<Q> valueOf(double d, double d2, double d3, Unit<Q> unit) {
        return new ThreeDimensional(d, d2, d3, unit);
    }

    public static <Q extends Quantity> VectorMeasure<Q> valueOf(double[] dArray, Unit<Q> unit) {
        return new MultiDimensional(dArray, unit);
    }

    public abstract VectorMeasure<Q> to(Unit<Q> var1);

    @Override
    public abstract double doubleValue(Unit<Q> var1);

    private static class MultiDimensional<Q extends Quantity>
    extends VectorMeasure<Q> {
        private final double[] _components;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        private MultiDimensional(double[] dArray, Unit<Q> unit) {
            this._components = (double[])dArray.clone();
            this._unit = unit;
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            double d = this._components[0] * this._components[0];
            int n = 1;
            int n2 = this._components.length;
            while (n < n2) {
                double d2 = this._components[n++];
                d += d2 * d2;
            }
            if (unit == this._unit || unit.equals(this._unit)) {
                return Math.sqrt(d);
            }
            return this._unit.getConverterTo(unit).convert(Math.sqrt(d));
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public double[] getValue() {
            return (double[])this._components.clone();
        }

        @Override
        public MultiDimensional<Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            UnitConverter unitConverter = this._unit.getConverterTo(unit);
            double[] dArray = new double[this._components.length];
            for (int i = 0; i < this._components.length; ++i) {
                dArray[i] = unitConverter.convert(this._components[i]);
            }
            return new MultiDimensional<Q>(dArray, unit);
        }
    }

    private static class ThreeDimensional<Q extends Quantity>
    extends VectorMeasure<Q> {
        private final double _x;
        private final double _y;
        private final double _z;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        private ThreeDimensional(double d, double d2, double d3, Unit<Q> unit) {
            this._x = d;
            this._y = d2;
            this._z = d3;
            this._unit = unit;
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            double d = Math.sqrt(this._x * this._x + this._y * this._y + this._z * this._z);
            if (unit == this._unit || unit.equals(this._unit)) {
                return d;
            }
            return this._unit.getConverterTo(unit).convert(d);
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public double[] getValue() {
            return new double[]{this._x, this._y, this._z};
        }

        @Override
        public ThreeDimensional<Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            UnitConverter unitConverter = this._unit.getConverterTo(unit);
            return new ThreeDimensional<Q>(unitConverter.convert(this._x), unitConverter.convert(this._y), unitConverter.convert(this._z), unit);
        }
    }

    private static class TwoDimensional<Q extends Quantity>
    extends VectorMeasure<Q> {
        private final double _x;
        private final double _y;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        private TwoDimensional(double d, double d2, Unit<Q> unit) {
            this._x = d;
            this._y = d2;
            this._unit = unit;
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            double d = Math.sqrt(this._x * this._x + this._y * this._y);
            if (unit == this._unit || unit.equals(this._unit)) {
                return d;
            }
            return this._unit.getConverterTo(unit).convert(d);
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public double[] getValue() {
            return new double[]{this._x, this._y};
        }

        @Override
        public TwoDimensional<Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            UnitConverter unitConverter = this._unit.getConverterTo(unit);
            return new TwoDimensional<Q>(unitConverter.convert(this._x), unitConverter.convert(this._y), unit);
        }
    }
}

