/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxData;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

class GPXLayerImportAction
extends AbstractAction {
    private static final long serialVersionUID = 5794897888911798168L;
    private EditGpxData data;
    public Object importing = new Object();

    public GPXLayerImportAction(EditGpxData data) {
        super(I18n.tr((String)"Import path from GPX layer", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"edit"));
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateImport() {
        Box panel = Box.createVerticalBox();
        DefaultListModel<Layer> dModel = new DefaultListModel<Layer>();
        final JList<Object> layerList = new JList<Object>(dModel);
        Collection data = Main.map.mapView.getAllLayers();
        int layerCnt = 0;
        for (Layer l : data) {
            if (!(l instanceof GpxLayer)) continue;
            dModel.addElement(l);
            ++layerCnt;
        }
        if (layerCnt > 0) {
            layerList.setSelectionInterval(0, layerCnt - 1);
            layerList.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Layer layer = (Layer)value;
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
                    Icon icon = layer.getIcon();
                    label.setIcon(icon);
                    label.setToolTipText(layer.getToolTipText());
                    return label;
                }
            });
            JCheckBox dropFirst = new JCheckBox(I18n.tr((String)"Drop existing path", (Object[])new Object[0]));
            dropFirst.setEnabled(!this.data.getTracks().isEmpty());
            panel.add(layerList);
            panel.add(dropFirst);
            JOptionPane optionPane = new JOptionPane(panel, 3, 2){

                public void selectInitialValue() {
                    layerList.requestFocusInWindow();
                }
            };
            JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr((String)"Import path from GPX layer", (Object[])new Object[0]));
            dlg.setVisible(true);
            Object answer = optionPane.getValue();
            if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
                return;
            }
            if (dropFirst.isSelected()) {
                this.data.getTracks().clear();
            }
            Object object = this.importing;
            synchronized (object) {
                for (Object o : layerList.getSelectedValues()) {
                    GpxLayer gpx = (GpxLayer)o;
                    this.data.load(gpx.data);
                }
            }
            Main.map.mapView.repaint();
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No GPX data layer found.", (Object[])new Object[0]));
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        this.activateImport();
    }
}

