/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.waypointSearch;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.waypointSearch.Engine;
import org.openstreetmap.josm.plugins.waypointSearch.SelectWaypointDialog;
import org.openstreetmap.josm.tools.I18n;

public class WaypointSearchPlugin
extends Plugin
implements MapView.LayerChangeListener {
    private Engine engine = new Engine();
    private SelectWaypointDialog waypointDialog = new SelectWaypointDialog(I18n.tr((String)"Waypoint search", (Object[])new Object[0]), "ToolbarIcon", I18n.tr((String)"Search after waypoint. Click and move the map view to the waypoint.", (Object[])new Object[0]), null, 100);

    public WaypointSearchPlugin(PluginInformation info) {
        super(info);
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (Main.map.getToggleDialog(SelectWaypointDialog.class) == null) {
            Main.map.addToggleDialog((ToggleDialog)this.waypointDialog);
        }
        if (this.engine.gpxLayersExist()) {
            this.waypointDialog.updateSearchResults();
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (!this.engine.gpxLayersExist()) {
            this.waypointDialog.updateSearchResults();
        }
    }
}

