/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;

public class MediaPlayerLatch {
    private final MediaPlayer mediaPlayer;
    private long timeout;
    private TimeUnit timeUnit;

    public MediaPlayerLatch(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play() {
        CountDownLatch latch = new CountDownLatch(1);
        LatchListener listener = new LatchListener(latch);
        this.mediaPlayer.addMediaPlayerEventListener(listener);
        this.mediaPlayer.play();
        try {
            if (this.timeout > 0L) {
                boolean bl = latch.await(this.timeout, this.timeUnit);
                return bl;
            }
            latch.await();
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.mediaPlayer.removeMediaPlayerEventListener(listener);
        }
        return false;
    }

    private final class LatchListener
    extends MediaPlayerEventAdapter {
        private CountDownLatch latch;

        private LatchListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void playing(MediaPlayer mediaPlayer) {
            this.latch.countDown();
            this.latch = null;
        }
    }
}

