/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_logo_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_stats_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_navigate_mode_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_state_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_adjust_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_marquee_option_t;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.TrackDescription;
import uk.co.caprica.vlcj.player.VideoMetaData;
import uk.co.caprica.vlcj.player.events.MediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MediaPlayer {
    private static final int VOUT_WAIT_PERIOD = 1000;
    protected final LibVlc libvlc = LibVlcFactory.factory().synchronise().log().create();
    private final List<MediaPlayerEventListener> eventListenerList = new ArrayList<MediaPlayerEventListener>();
    private final MediaPlayerEventFactory eventFactory = new MediaPlayerEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final ExecutorService metaService = Executors.newSingleThreadExecutor();
    private libvlc_instance_t instance;
    private libvlc_media_player_t mediaPlayerInstance;
    private libvlc_event_manager_t mediaPlayerEventManager;
    private libvlc_callback_t callback;
    private String[] standardMediaOptions;
    private libvlc_media_stats_t libvlcMediaStats;
    private boolean playSubItems;
    private AtomicBoolean released = new AtomicBoolean();

    public MediaPlayer(libvlc_instance_t instance) {
        Logger.debug("MediaPlayer(instance={})", instance);
        this.instance = instance;
        this.createInstance();
    }

    public void addMediaPlayerEventListener(MediaPlayerEventListener listener) {
        Logger.debug("addMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.add(listener);
    }

    public void removeMediaPlayerEventListener(MediaPlayerEventListener listener) {
        Logger.debug("removeMediaPlayerEventListener(listener={})", listener);
        this.eventListenerList.remove(listener);
    }

    public void setStandardMediaOptions(String ... options) {
        Logger.debug("setStandardMediaOptions(options={})", Arrays.toString(options));
        this.standardMediaOptions = options;
    }

    public void playMedia(String mrl) {
        Logger.debug("playMedia(mrl={})", mrl);
        this.playMedia(mrl, null);
    }

    public void playMedia(String mrl, String ... mediaOptions) {
        Logger.debug("playMedia(mrl={},mediaOptions={})", mrl, Arrays.toString(mediaOptions));
        this.prepareMedia(mrl, mediaOptions);
        this.play();
    }

    public void prepareMedia(String mrl) {
        Logger.debug("prepareMedia(mrl={})", mrl);
        this.prepareMedia(mrl, null);
    }

    public void prepareMedia(String mrl, String ... mediaOptions) {
        Logger.debug("prepareMedia(mrl={},mediaOptions={})", mrl, Arrays.toString(mediaOptions));
        this.setMedia(mrl, mediaOptions);
    }

    public void addMediaOptions(String ... mediaOptions) {
        Logger.debug("addMediaOptions(mediaOptions={})", Arrays.toString(mediaOptions));
        libvlc_media_t media = this.libvlc.libvlc_media_player_get_media(this.mediaPlayerInstance);
        Logger.trace("media={}", media);
        if (media != null) {
            for (String mediaOption : mediaOptions) {
                Logger.debug("mediaOption={}", mediaOption);
                this.libvlc.libvlc_media_add_option(media, mediaOption);
            }
        } else {
            throw new RuntimeException("No media");
        }
        this.libvlc.libvlc_media_release(media);
    }

    public void setPlaySubItems(boolean playSubItems) {
        Logger.debug("setPlaySubItems(playSubItems={})", playSubItems);
        this.playSubItems = playSubItems;
    }

    public boolean playNextSubItem() {
        Logger.debug("playNextSubItem()", new Object[0]);
        boolean subItemPlayed = false;
        libvlc_media_t media = this.libvlc.libvlc_media_player_get_media(this.mediaPlayerInstance);
        Logger.trace("media={}", media);
        if (media != null) {
            libvlc_media_list_t subItems = this.libvlc.libvlc_media_subitems(media);
            Logger.trace("subItems={}", subItems);
            if (subItems != null) {
                Logger.debug("Handling media sub-item...", new Object[0]);
                this.libvlc.libvlc_media_list_lock(subItems);
                libvlc_media_t subItem = this.libvlc.libvlc_media_list_item_at_index(subItems, 0);
                if (subItem != null) {
                    this.libvlc.libvlc_media_player_set_media(this.mediaPlayerInstance, subItem);
                    this.libvlc.libvlc_media_player_play(this.mediaPlayerInstance);
                    this.libvlc.libvlc_media_release(subItem);
                    subItemPlayed = true;
                }
                this.libvlc.libvlc_media_list_unlock(subItems);
                this.libvlc.libvlc_media_list_release(subItems);
            }
        }
        Logger.debug("subItemPlayed={}", subItemPlayed);
        return subItemPlayed;
    }

    public boolean isPlayable() {
        Logger.trace("isPlayable()", new Object[0]);
        return this.libvlc.libvlc_media_player_will_play(this.mediaPlayerInstance) == 1;
    }

    public boolean isPlaying() {
        Logger.trace("isPlaying()", new Object[0]);
        return this.libvlc.libvlc_media_player_is_playing(this.mediaPlayerInstance) == 1;
    }

    public boolean isSeekable() {
        Logger.trace("isSeekable()", new Object[0]);
        return this.libvlc.libvlc_media_player_is_seekable(this.mediaPlayerInstance) == 1;
    }

    public boolean canPause() {
        Logger.trace("canPause()", new Object[0]);
        return this.libvlc.libvlc_media_player_can_pause(this.mediaPlayerInstance) == 1;
    }

    public long getLength() {
        Logger.trace("getLength()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_length(this.mediaPlayerInstance);
    }

    public long getTime() {
        Logger.trace("getTime()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_time(this.mediaPlayerInstance);
    }

    public float getPosition() {
        Logger.trace("getPosition()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_position(this.mediaPlayerInstance);
    }

    public float getFps() {
        Logger.trace("getFps()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_fps(this.mediaPlayerInstance);
    }

    public float getRate() {
        Logger.trace("getRate()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_rate(this.mediaPlayerInstance);
    }

    public int getVideoOutputs() {
        Logger.trace("getVideoOutputs()", new Object[0]);
        return this.libvlc.libvlc_media_player_has_vout(this.mediaPlayerInstance);
    }

    public Dimension getVideoDimension() {
        Logger.debug("getVideoDimension()", new Object[0]);
        IntByReference px = new IntByReference();
        IntByReference py = new IntByReference();
        int result = this.libvlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, px, py);
        if (result == 0) {
            return new Dimension(px.getValue(), py.getValue());
        }
        return null;
    }

    public String getAspectRatio() {
        Logger.debug("getAspectRatio()", new Object[0]);
        return this.libvlc.libvlc_video_get_aspect_ratio(this.mediaPlayerInstance);
    }

    public float getScale() {
        Logger.debug("getScale()", new Object[0]);
        return this.libvlc.libvlc_video_get_scale(this.mediaPlayerInstance);
    }

    public String getCropGeometry() {
        Logger.debug("getCropGeometry()", new Object[0]);
        return this.libvlc.libvlc_video_get_crop_geometry(this.mediaPlayerInstance);
    }

    public libvlc_media_stats_t getMediaStatistics() {
        libvlc_media_t mediaDescriptor;
        Logger.debug("getMediaStatistics()", new Object[0]);
        if (this.isPlaying() && (mediaDescriptor = this.libvlc.libvlc_media_player_get_media(this.mediaPlayerInstance)) != null) {
            this.libvlc.libvlc_media_get_stats(mediaDescriptor, this.libvlcMediaStats);
            this.libvlc.libvlc_media_release(mediaDescriptor);
        }
        return this.libvlcMediaStats;
    }

    public libvlc_state_t getMediaState() {
        Logger.debug("getMediaState()", new Object[0]);
        libvlc_state_t state = null;
        libvlc_media_t mediaDescriptor = this.libvlc.libvlc_media_player_get_media(this.mediaPlayerInstance);
        if (mediaDescriptor != null) {
            state = libvlc_state_t.state(this.libvlc.libvlc_media_get_state(mediaDescriptor));
            this.libvlc.libvlc_media_release(mediaDescriptor);
        }
        return state;
    }

    public libvlc_state_t getMediaPlayerState() {
        Logger.debug("getMediaPlayerState()", new Object[0]);
        return libvlc_state_t.state(this.libvlc.libvlc_media_player_get_state(this.mediaPlayerInstance));
    }

    public int getTitleCount() {
        Logger.debug("getTitleCount()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_title_count(this.mediaPlayerInstance);
    }

    public int getTitle() {
        Logger.debug("getTitle()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_title(this.mediaPlayerInstance);
    }

    public void setTitle(int title) {
        Logger.debug("setTitle(title={})", title);
        this.libvlc.libvlc_media_player_set_title(this.mediaPlayerInstance, title);
    }

    public int getVideoTrackCount() {
        Logger.debug("getVideoTrackCount()", new Object[0]);
        return this.libvlc.libvlc_video_get_track_count(this.mediaPlayerInstance);
    }

    public int getVideoTrack() {
        Logger.debug("getVideoTrack()", new Object[0]);
        return this.libvlc.libvlc_video_get_track(this.mediaPlayerInstance);
    }

    public void setVideoTrack(int track) {
        Logger.debug("setVideoTrack(track={})", track);
        this.libvlc.libvlc_video_set_track(this.mediaPlayerInstance, track);
    }

    public int getAudioTrackCount() {
        Logger.debug("getVideoTrackCount()", new Object[0]);
        return this.libvlc.libvlc_audio_get_track_count(this.mediaPlayerInstance);
    }

    public int getAudioTrack() {
        Logger.debug("getAudioTrack()", new Object[0]);
        return this.libvlc.libvlc_audio_get_track(this.mediaPlayerInstance);
    }

    public void setAudioTrack(int track) {
        Logger.debug("setAudioTrack(track={})", track);
        this.libvlc.libvlc_audio_set_track(this.mediaPlayerInstance, track);
    }

    public void play() {
        Logger.debug("play()", new Object[0]);
        this.onBeforePlay();
        this.libvlc.libvlc_media_player_play(this.mediaPlayerInstance);
    }

    public void stop() {
        Logger.debug("stop()", new Object[0]);
        this.libvlc.libvlc_media_player_stop(this.mediaPlayerInstance);
    }

    public void setPause(boolean pause) {
        Logger.debug("setPause(pause={})", pause);
        this.libvlc.libvlc_media_player_set_pause(this.mediaPlayerInstance, pause ? 1 : 0);
    }

    public void pause() {
        Logger.debug("pause()", new Object[0]);
        this.libvlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    public void nextFrame() {
        Logger.debug("nextFrame()", new Object[0]);
        this.libvlc.libvlc_media_player_next_frame(this.mediaPlayerInstance);
    }

    public void skip(long delta) {
        Logger.debug("skip(delta={})", delta);
        long current = this.getTime();
        Logger.debug("current={}", current);
        if (current != -1L) {
            this.setTime(current + delta);
        }
    }

    public void skip(float delta) {
        Logger.debug("skip(delta={})", Float.valueOf(delta));
        float current = this.getPosition();
        Logger.debug("current={}", Float.valueOf(current));
        if (current != -1.0f) {
            this.setPosition(current + delta);
        }
    }

    public void setTime(long time) {
        Logger.debug("setTime(time={})", time);
        this.libvlc.libvlc_media_player_set_time(this.mediaPlayerInstance, time);
    }

    public void setPosition(float position) {
        Logger.debug("setPosition(position={})", Float.valueOf(position));
        this.libvlc.libvlc_media_player_set_position(this.mediaPlayerInstance, position);
    }

    public int setRate(float rate) {
        Logger.debug("setRate(rate={})", Float.valueOf(rate));
        return this.libvlc.libvlc_media_player_set_rate(this.mediaPlayerInstance, rate);
    }

    public void setAspectRatio(String aspectRatio) {
        Logger.debug("setAspectRatio(aspectRatio={})", aspectRatio);
        this.libvlc.libvlc_video_set_aspect_ratio(this.mediaPlayerInstance, aspectRatio);
    }

    public void setScale(float factor) {
        Logger.debug("setScale(factor={})", Float.valueOf(factor));
        this.libvlc.libvlc_video_set_scale(this.mediaPlayerInstance, factor);
    }

    public void setCropGeometry(String cropGeometry) {
        Logger.debug("setCropGeometry(cropGeometry={})", cropGeometry);
        this.libvlc.libvlc_video_set_crop_geometry(this.mediaPlayerInstance, cropGeometry);
    }

    public void selectAudioOutput(String outputName) {
        Logger.debug("selectAudioOutput(outputName={})", outputName);
        this.libvlc.libvlc_audio_output_set(this.mediaPlayerInstance, outputName);
    }

    public void mute() {
        Logger.debug("mute()", new Object[0]);
        this.libvlc.libvlc_audio_toggle_mute(this.mediaPlayerInstance);
    }

    public void mute(boolean mute) {
        Logger.debug("mute(mute={})", mute);
        this.libvlc.libvlc_audio_set_mute(this.mediaPlayerInstance, mute ? 1 : 0);
    }

    public boolean isMute() {
        Logger.debug("isMute()", new Object[0]);
        return this.libvlc.libvlc_audio_get_mute(this.mediaPlayerInstance) != 0;
    }

    public int getVolume() {
        Logger.debug("getVolume()", new Object[0]);
        return this.libvlc.libvlc_audio_get_volume(this.mediaPlayerInstance);
    }

    public void setVolume(int volume) {
        Logger.debug("setVolume(volume={})", volume);
        this.libvlc.libvlc_audio_set_volume(this.mediaPlayerInstance, volume);
    }

    public int getAudioChannel() {
        Logger.debug("getAudioChannel()", new Object[0]);
        return this.libvlc.libvlc_audio_get_channel(this.mediaPlayerInstance);
    }

    public void setAudioChannel(int channel) {
        Logger.debug("setAudioChannel(channel={})", channel);
        this.libvlc.libvlc_audio_set_channel(this.mediaPlayerInstance, channel);
    }

    public long getAudioDelay() {
        Logger.debug("getAudioDelay()", new Object[0]);
        return this.libvlc.libvlc_audio_get_delay(this.mediaPlayerInstance);
    }

    public void setAudioDelay(long delay) {
        Logger.debug("setAudioDelay(delay={})", delay);
        this.libvlc.libvlc_audio_set_delay(this.mediaPlayerInstance, delay);
    }

    public int getChapterCount() {
        Logger.trace("getChapterCount()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_chapter_count(this.mediaPlayerInstance);
    }

    public int getChapter() {
        Logger.trace("getChapter()", new Object[0]);
        return this.libvlc.libvlc_media_player_get_chapter(this.mediaPlayerInstance);
    }

    public void setChapter(int chapterNumber) {
        Logger.debug("setChapter(chapterNumber={})", chapterNumber);
        this.libvlc.libvlc_media_player_set_chapter(this.mediaPlayerInstance, chapterNumber);
    }

    public void nextChapter() {
        Logger.debug("nextChapter()", new Object[0]);
        this.libvlc.libvlc_media_player_next_chapter(this.mediaPlayerInstance);
    }

    public void previousChapter() {
        Logger.debug("previousChapter()", new Object[0]);
        this.libvlc.libvlc_media_player_previous_chapter(this.mediaPlayerInstance);
    }

    public void menuActivate() {
        Logger.debug("menuActivate()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_activate.intValue());
    }

    public void menuUp() {
        Logger.debug("menuUp()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_up.intValue());
    }

    public void menuDown() {
        Logger.debug("menuDown()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_down.intValue());
    }

    public void menuLeft() {
        Logger.debug("menuLeft()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_left.intValue());
    }

    public void menuRight() {
        Logger.debug("menuRight()", new Object[0]);
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_right.intValue());
    }

    public int getSpuCount() {
        Logger.debug("getSpuCount()", new Object[0]);
        return this.libvlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    public int getSpu() {
        Logger.debug("getSpu()", new Object[0]);
        return this.libvlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    public void setSpu(int spu) {
        Logger.debug("setSpu(spu={})", spu);
        int spuCount = this.getSpuCount();
        Logger.debug("spuCount={}", spuCount);
        if (spuCount != 0 && spu <= spuCount) {
            this.libvlc.libvlc_video_set_spu(this.mediaPlayerInstance, spu);
        } else {
            Logger.debug("Ignored out of range spu number {} because spu count is {}", spu, spuCount);
        }
    }

    public void cycleSpu() {
        Logger.debug("cycleSpu()", new Object[0]);
        int spu = this.getSpu();
        int spuCount = this.getSpuCount();
        spu = spu >= spuCount ? 0 : ++spu;
        this.setSpu(spu);
    }

    public List<TrackDescription> getTitleDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getTitleDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_title_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    public List<TrackDescription> getVideoDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getVideoDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_track_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    public List<TrackDescription> getAudioDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getAudioDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_audio_get_track_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    public List<TrackDescription> getSpuDescriptions() {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getSpuDescriptions()", new Object[0]);
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_spu_description(this.mediaPlayerInstance);
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    public List<String> getChapterDescriptions(int title) {
        libvlc_track_description_t trackDescriptions;
        Logger.debug("getChapterDescriptions(title={})", title);
        ArrayList<String> trackDescriptionList = new ArrayList<String>();
        libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_chapter_description(this.mediaPlayerInstance, title);
        while (trackDescription != null) {
            trackDescriptionList.add(trackDescription.psz_name);
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    public void saveSnapshot() {
        Logger.debug("saveSnapshot()", new Object[0]);
        File snapshotDirectory = new File(System.getProperty("user.home"));
        File snapshotFile = new File(snapshotDirectory, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        this.saveSnapshot(snapshotFile);
    }

    public void saveSnapshot(File file) {
        Logger.debug("saveSnapshot(file={})", file);
        File snapshotDirectory = file.getParentFile();
        if (!snapshotDirectory.exists()) {
            snapshotDirectory.mkdirs();
        }
        if (!snapshotDirectory.exists()) {
            throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
        }
        this.libvlc.libvlc_video_take_snapshot(this.mediaPlayerInstance, 0, file.getAbsolutePath(), 0, 0);
    }

    public BufferedImage getSnapshot() {
        Logger.debug("getSnapshot()", new Object[0]);
        try {
            File file = File.createTempFile("vlcj-snapshot-", ".png");
            Logger.debug("file={}", file.getAbsolutePath());
            this.saveSnapshot(file);
            BufferedImage snapshotImage = ImageIO.read(file);
            boolean deleted = file.delete();
            Logger.debug("deleted={}", deleted);
            return snapshotImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get snapshot image", e);
        }
    }

    public void enableLogo(boolean enable) {
        Logger.debug("enableLogo(enable={})", enable);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), enable ? 1 : 0);
    }

    public void setLogoOpacity(int opacity) {
        Logger.debug("setLogoOpacity(opacity={})", opacity);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacity);
    }

    public void setLogoOpacity(float opacity) {
        Logger.debug("setLogoOpacity(opacity={})", Float.valueOf(opacity));
        int opacityValue = Math.round(opacity * 255.0f);
        Logger.debug("opacityValue={}", opacityValue);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacityValue);
    }

    public void setLogoLocation(int x, int y) {
        Logger.debug("setLogoLocation(x={},y={})", x, y);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), x);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), y);
    }

    public void setLogoPosition(libvlc_logo_position_e position) {
        Logger.debug("setLogoPosition(position={})", new Object[]{position});
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_position.intValue(), position.intValue());
    }

    public void setLogoFile(String logoFile) {
        Logger.debug("setLogoFile(logoFile={})", logoFile);
        this.libvlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), logoFile);
    }

    public void enableMarquee(boolean enable) {
        Logger.debug("enableMarquee(enable={})", enable);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Enable.intValue(), enable ? 1 : 0);
    }

    public void setMarqueeText(String text) {
        Logger.debug("setMarqueeText(text={})", text);
        this.libvlc.libvlc_video_set_marquee_string(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Text.intValue(), text);
    }

    public void setMarqueeColour(Color colour) {
        Logger.debug("setMarqueeColour(colour={})", colour);
        this.setMarqueeColour(colour.getRGB() & 0xFFFFFF);
    }

    public void setMarqueeColour(int colour) {
        Logger.debug("setMarqueeColour(colour={})", colour);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Color.intValue(), colour);
    }

    public void setMarqueeOpacity(int opacity) {
        Logger.debug("setMarqueeOpacity(opacity={})", opacity);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacity);
    }

    public void setMarqueeOpacity(float opacity) {
        Logger.debug("setMarqueeOpacity(opacity={})", Float.valueOf(opacity));
        int opacityValue = Math.round(opacity * 255.0f);
        Logger.debug("opacityValue={}", opacityValue);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacityValue);
    }

    public void setMarqueeSize(int size) {
        Logger.debug("setMarqueeSize(size={})", size);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Size.intValue(), size);
    }

    public void setMarqueeTimeout(int timeout) {
        Logger.debug("setMarqueeTimeout(timeout={})", timeout);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Timeout.intValue(), timeout);
    }

    public void setMarqueeLocation(int x, int y) {
        Logger.debug("setMarqueeLocation(x={},y={})", x, y);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_X.intValue(), x);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Y.intValue(), y);
    }

    public void setDeinterlace(String deinterlaceMode) {
        Logger.debug("setDeinterlace(deinterlaceMode={})", deinterlaceMode);
        this.libvlc.libvlc_video_set_deinterlace(this.mediaPlayerInstance, deinterlaceMode);
    }

    public void setAdjustVideo(boolean adjustVideo) {
        Logger.debug("setAdjustVideo(adjustVideo={})", adjustVideo);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue(), adjustVideo ? 1 : 0);
    }

    public boolean isAdjustVideo() {
        Logger.debug("isAdjustVideo()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue()) == 1;
    }

    public float getContrast() {
        Logger.debug("getContrast()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue());
    }

    public void setContrast(float contrast) {
        Logger.debug("setContrast(contrast={})", Float.valueOf(contrast));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue(), contrast);
    }

    public float getBrightness() {
        Logger.debug("getBrightness()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue());
    }

    public void setBrightness(float brightness) {
        Logger.debug("setBrightness(brightness={})", Float.valueOf(brightness));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue(), brightness);
    }

    public int getHue() {
        Logger.debug("getHue()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue());
    }

    public void setHue(int hue) {
        Logger.debug("setHue(hue={})", hue);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue(), hue);
    }

    public float getSaturation() {
        Logger.debug("getSaturation()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue());
    }

    public void setSaturation(float saturation) {
        Logger.debug("setSaturation(saturation={})", Float.valueOf(saturation));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue(), saturation);
    }

    public float getGamma() {
        Logger.debug("getGamma()", new Object[0]);
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue());
    }

    public void setGamma(float gamma) {
        Logger.debug("setGamma(gamma={})", Float.valueOf(gamma));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue(), gamma);
    }

    public void setEnableMouseInputHandling(boolean enable) {
        Logger.debug("setEnableMouseInputHandling(enable={})", enable);
        this.libvlc.libvlc_video_set_mouse_input(this.mediaPlayerInstance, enable ? 1 : 0);
    }

    public void setEnableKeyInputHandling(boolean enable) {
        Logger.debug("setEnableKeyInputHandling(enable={})", enable);
        this.libvlc.libvlc_video_set_key_input(this.mediaPlayerInstance, enable ? 1 : 0);
    }

    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
            this.onAfterRelease();
        }
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
        this.mediaPlayerInstance = this.libvlc.libvlc_media_player_new(this.instance);
        Logger.debug("mediaPlayerInstance={}", this.mediaPlayerInstance);
        this.mediaPlayerEventManager = this.libvlc.libvlc_media_player_event_manager(this.mediaPlayerInstance);
        Logger.debug("mediaPlayerEventManager={}", this.mediaPlayerEventManager);
        this.registerEventListener();
        this.eventListenerList.add(new MetaDataEventHandler());
        this.eventListenerList.add(new SubItemEventHandler());
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        Logger.debug("Detach events...", new Object[0]);
        this.deregisterEventListener();
        Logger.debug("Events detached.", new Object[0]);
        this.eventListenerList.clear();
        if (this.mediaPlayerInstance != null) {
            Logger.debug("Release media player...", new Object[0]);
            this.libvlc.libvlc_media_player_release(this.mediaPlayerInstance);
            Logger.debug("Media player released", new Object[0]);
        }
        Logger.debug("Shut down listeners...", new Object[0]);
        this.listenersService.shutdown();
        Logger.debug("Listeners shut down", new Object[0]);
        this.metaService.shutdown();
    }

    private void registerEventListener() {
        Logger.debug("registerEventListener()", new Object[0]);
        this.callback = new VlcVideoPlayerCallback();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaPlayerLengthChanged.intValue()) continue;
            Logger.debug("event={}", new Object[]{event});
            int result = this.libvlc.libvlc_event_attach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            Logger.debug("result={}", result);
        }
    }

    private void deregisterEventListener() {
        Logger.debug("deregisterEventListener()", new Object[0]);
        if (this.callback != null) {
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() > libvlc_event_e.libvlc_MediaPlayerLengthChanged.intValue()) continue;
                Logger.debug("event={}", new Object[]{event});
                this.libvlc.libvlc_event_detach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private void setMedia(String media, String ... mediaOptions) {
        Logger.debug("setMedia(media={},mediaOptions={})", media, Arrays.toString(mediaOptions));
        libvlc_media_t mediaDescriptor = this.libvlc.libvlc_media_new_path(this.instance, media);
        Logger.debug("mediaDescriptor={}", mediaDescriptor);
        if (this.standardMediaOptions != null) {
            for (String standardMediaOption : this.standardMediaOptions) {
                Logger.debug("standardMediaOption={}", standardMediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, standardMediaOption);
            }
        }
        if (mediaOptions != null) {
            for (String mediaOption : mediaOptions) {
                Logger.debug("mediaOption={}", mediaOption);
                this.libvlc.libvlc_media_add_option(mediaDescriptor, mediaOption);
            }
        }
        this.libvlc.libvlc_media_player_set_media(this.mediaPlayerInstance, mediaDescriptor);
        this.libvlc.libvlc_media_release(mediaDescriptor);
        this.libvlcMediaStats = new libvlc_media_stats_t();
    }

    private void notifyListeners(VideoMetaData videoMetaData) {
        Logger.trace("notifyListeners(videoMetaData={})", videoMetaData);
        if (!this.eventListenerList.isEmpty()) {
            for (int i = this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = this.eventListenerList.get(i);
                listener.metaDataAvailable(this, videoMetaData);
            }
        }
    }

    public final libvlc_media_player_t mediaPlayerInstance() {
        return this.mediaPlayerInstance;
    }

    protected void onBeforePlay() {
    }

    protected void onAfterRelease() {
    }

    private final class SubItemEventHandler
    extends MediaPlayerEventAdapter {
        private SubItemEventHandler() {
        }

        public void finished(MediaPlayer mediaPlayer) {
            Logger.trace("finished(mediaPlayer={})", mediaPlayer);
            if (MediaPlayer.this.playSubItems) {
                MediaPlayer.this.playNextSubItem();
            }
        }
    }

    private final class MetaDataEventHandler
    extends MediaPlayerEventAdapter {
        private MetaDataEventHandler() {
        }

        public void playing(MediaPlayer mediaPlayer) {
            Logger.trace("playing(mediaPlayer={})", mediaPlayer);
            MediaPlayer.this.metaService.submit(new NotifyMetaRunnable());
        }
    }

    private final class NotifyMetaRunnable
    implements Runnable {
        private NotifyMetaRunnable() {
        }

        public void run() {
            Logger.trace("run()", new Object[0]);
            while (true) {
                try {
                    boolean isPlaying;
                    do {
                        Logger.trace("Waiting for video output...", new Object[0]);
                        Thread.sleep(1000L);
                        Logger.trace("Checking for video output...", new Object[0]);
                        int videoOutputs = MediaPlayer.this.getVideoOutputs();
                        Logger.trace("videoOutputs={}", videoOutputs);
                    } while (!(isPlaying = MediaPlayer.this.isPlaying()));
                    VideoMetaData videoMetaData = new VideoMetaData();
                    videoMetaData.setVideoDimension(MediaPlayer.this.getVideoDimension());
                    videoMetaData.setTitleCount(MediaPlayer.this.getTitleCount());
                    videoMetaData.setVideoTrackCount(MediaPlayer.this.getVideoTrackCount());
                    videoMetaData.setAudioTrackCount(MediaPlayer.this.getAudioTrackCount());
                    videoMetaData.setSpuCount(MediaPlayer.this.getSpuCount());
                    videoMetaData.setTitleDescriptions(MediaPlayer.this.getTitleDescriptions());
                    videoMetaData.setVideoDescriptions(MediaPlayer.this.getVideoDescriptions());
                    videoMetaData.setAudioDescriptions(MediaPlayer.this.getAudioDescriptions());
                    videoMetaData.setSpuDescriptions(MediaPlayer.this.getSpuDescriptions());
                    TreeMap<Integer, List<String>> allChapterDescriptions = new TreeMap<Integer, List<String>>();
                    for (int i = 0; i < MediaPlayer.this.getTitleCount(); ++i) {
                        allChapterDescriptions.put(i, MediaPlayer.this.getChapterDescriptions(i));
                    }
                    videoMetaData.setChapterDescriptions(allChapterDescriptions);
                    MediaPlayer.this.notifyListeners(videoMetaData);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class NotifyListenersRunnable
    implements Runnable {
        private final MediaPlayerEvent mediaPlayerEvent;

        private NotifyListenersRunnable(MediaPlayerEvent mediaPlayerEvent) {
            this.mediaPlayerEvent = mediaPlayerEvent;
        }

        public void run() {
            Logger.trace("run()", new Object[0]);
            for (int i = MediaPlayer.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = (MediaPlayerEventListener)MediaPlayer.this.eventListenerList.get(i);
                try {
                    this.mediaPlayerEvent.notify(listener);
                    continue;
                }
                catch (Throwable t) {
                    Logger.warn("Event listener {} threw an exception", t, listener);
                }
            }
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class VlcVideoPlayerCallback
    implements libvlc_callback_t {
        private VlcVideoPlayerCallback() {
        }

        public void callback(libvlc_event_t event, Pointer userData) {
            Logger.trace("callback(event={},userData={})", event, userData);
            if (!MediaPlayer.this.eventListenerList.isEmpty()) {
                MediaPlayerEvent mediaPlayerEvent = MediaPlayer.this.eventFactory.newMediaPlayerEvent(event);
                Logger.trace("mediaPlayerEvent={}", mediaPlayerEvent);
                if (mediaPlayerEvent != null) {
                    MediaPlayer.this.listenersService.submit(new NotifyListenersRunnable(mediaPlayerEvent));
                }
            }
        }
    }
}

