/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class WikipediaCopyTemplate {
    public WikipediaCopyTemplate() {
        CoordCopyTemplate coord = new CoordCopyTemplate(I18n.tr((String)"Copy '{{Coord}}' template", (Object[])new Object[0]), "wikipedia-coord", "{{Coord|{lat}|{lon}}}");
        CoordCopyTemplate coordinate = new CoordCopyTemplate(I18n.tr((String)"Copy '{{Coordinate}}' template", (Object[])new Object[0]), "wikipedia-coordinate", "{{Coordinate|NS={lat}|EW={lon}|type=landmark|region=}}");
        MainMenu.addAfter((JMenu)Main.main.menu.editMenu, (JosmAction)coord, (boolean)false, (JosmAction)Main.main.menu.copyCoordinates);
        MainMenu.addAfter((JMenu)Main.main.menu.editMenu, (JosmAction)coordinate, (boolean)false, (JosmAction)Main.main.menu.copyCoordinates);
    }

    private static class CoordCopyTemplate
    extends JosmAction {
        protected final String pattern;

        public CoordCopyTemplate(String name, String toolbarId, String pattern) {
            super(name, "dialogs/wikipedia", null, null, false, toolbarId, true);
            this.pattern = pattern;
        }

        public void actionPerformed(ActionEvent e) {
            Node node = this.getSelectedNode();
            if (node == null) {
                return;
            }
            Utils.copyToClipboard((String)this.pattern.replace("{lat}", Double.toString(node.getCoor().lat())).replace("{lon}", Double.toString(node.getCoor().lon())));
        }

        protected void updateEnabledState() {
            this.setEnabled(this.getSelectedNode() != null);
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
            this.updateEnabledState();
        }

        protected Node getSelectedNode() {
            if (CoordCopyTemplate.getCurrentDataSet() == null || CoordCopyTemplate.getCurrentDataSet().getSelected() == null) {
                return null;
            }
            SubclassFilteredCollection nodes = Utils.filteredCollection((Collection)CoordCopyTemplate.getCurrentDataSet().getSelected(), Node.class);
            return nodes.isEmpty() ? null : (Node)nodes.iterator().next();
        }
    }
}

