/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Symbols;

public abstract class AbstractParser {
    private static final boolean SCIENTIFIC_NOTATION = true;
    final Symbols symbols;
    private final NumberFormat numberFormat;

    public AbstractParser(Symbols symbols) {
        DecimalFormat decimalFormat;
        String string;
        this.symbols = symbols;
        this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        if (this.numberFormat instanceof DecimalFormat && (string = (decimalFormat = (DecimalFormat)this.numberFormat).toPattern()).indexOf("E0") < 0) {
            int n = string.indexOf(59);
            if (n >= 0) {
                string = string.substring(0, n) + "E0" + string.substring(n);
            }
            string = string + "E0";
            decimalFormat.applyPattern(string);
        }
    }

    public final Object parseObject(String string) throws ParseException {
        Element element = this.getTree(string, new ParsePosition(0));
        Object object = this.parse(element);
        element.close();
        return object;
    }

    final Number parseNumber(String string, ParsePosition parsePosition) {
        int n;
        int n2 = parsePosition.getIndex();
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number != null && (n = parsePosition.getIndex()) < string.length() && string.charAt(n) == 'e') {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(n, 'E');
            string = stringBuilder.toString();
            parsePosition.setIndex(n2);
            number = this.numberFormat.parse(string, parsePosition);
        }
        return number;
    }

    protected abstract Object parse(Element var1) throws ParseException;

    protected final Element getTree(String string, ParsePosition parsePosition) throws ParseException {
        return new Element(new Element(this, string, parsePosition));
    }
}

