/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.InternationalString;

public class ContactImpl
extends MetadataEntity
implements Contact {
    private static final long serialVersionUID = 3283637180253117382L;
    public static final Contact OGC;
    public static final Contact OPEN_GIS;
    public static final Contact EPSG;
    public static final Contact GEOTIFF;
    public static final Contact ESRI;
    public static final Contact ORACLE;
    public static final Contact SUN_MICROSYSTEMS;
    public static final Contact GEOTOOLS;
    private InternationalString contactInstructions;
    private InternationalString hoursOfService;
    private OnLineResource onLineResource;
    private Address address;
    private Telephone phone;

    public ContactImpl() {
    }

    public ContactImpl(OnLineResource onLineResource) {
        this.setOnLineResource(onLineResource);
    }

    public Address getAddress() {
        return this.address;
    }

    public synchronized void setAddress(Address address) {
        this.checkWritePermission();
        this.address = address;
    }

    public InternationalString getContactInstructions() {
        return this.contactInstructions;
    }

    public synchronized void setContactInstructions(InternationalString internationalString) {
        this.checkWritePermission();
        this.contactInstructions = internationalString;
    }

    public OnLineResource getOnLineResource() {
        return this.onLineResource;
    }

    public synchronized void setOnLineResource(OnLineResource onLineResource) {
        this.checkWritePermission();
        this.onLineResource = onLineResource;
    }

    public Telephone getPhone() {
        return this.phone;
    }

    public synchronized void setPhone(Telephone telephone) {
        this.checkWritePermission();
        this.phone = telephone;
    }

    public InternationalString getHoursOfService() {
        return this.hoursOfService;
    }

    public synchronized void setHoursOfService(InternationalString internationalString) {
        this.checkWritePermission();
        this.hoursOfService = internationalString;
    }

    static {
        ContactImpl contactImpl = new ContactImpl(OnLineResourceImpl.OGC);
        contactImpl.freeze();
        OGC = contactImpl;
        contactImpl = new ContactImpl(OnLineResourceImpl.OPEN_GIS);
        contactImpl.freeze();
        OPEN_GIS = contactImpl;
        contactImpl = new ContactImpl(OnLineResourceImpl.EPSG);
        contactImpl.freeze();
        EPSG = contactImpl;
        contactImpl = new ContactImpl(OnLineResourceImpl.GEOTIFF);
        contactImpl.freeze();
        GEOTIFF = contactImpl;
        contactImpl = new ContactImpl(OnLineResourceImpl.ESRI);
        contactImpl.freeze();
        ESRI = contactImpl;
        contactImpl = new ContactImpl(OnLineResourceImpl.ORACLE);
        contactImpl.freeze();
        ORACLE = contactImpl;
        contactImpl = new ContactImpl(OnLineResourceImpl.SUN_MICROSYSTEMS);
        contactImpl.freeze();
        SUN_MICROSYSTEMS = contactImpl;
        contactImpl = new ContactImpl(OnLineResourceImpl.GEOTOOLS);
        contactImpl.freeze();
        GEOTOOLS = contactImpl;
    }
}

